// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// AppServiceDomain.
/// </summary>
public partial class AppServiceDomain : ProvisionableResource
{
    /// <summary>
    /// Name of the domain.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Gets or sets the auth code.
    /// </summary>
    public BicepValue<string> AuthCode 
    {
        get { Initialize(); return _authCode!; }
        set { Initialize(); _authCode!.Assign(value); }
    }
    private BicepValue<string>? _authCode;

    /// <summary>
    /// Legal agreement consent.
    /// </summary>
    public DomainPurchaseConsent Consent 
    {
        get { Initialize(); return _consent!; }
        set { Initialize(); AssignOrReplace(ref _consent, value); }
    }
    private DomainPurchaseConsent? _consent;

    /// <summary>
    /// Administrative contact.
    /// </summary>
    public RegistrationContactInfo ContactAdmin 
    {
        get { Initialize(); return _contactAdmin!; }
        set { Initialize(); AssignOrReplace(ref _contactAdmin, value); }
    }
    private RegistrationContactInfo? _contactAdmin;

    /// <summary>
    /// Billing contact.
    /// </summary>
    public RegistrationContactInfo ContactBilling 
    {
        get { Initialize(); return _contactBilling!; }
        set { Initialize(); AssignOrReplace(ref _contactBilling, value); }
    }
    private RegistrationContactInfo? _contactBilling;

    /// <summary>
    /// Registrant contact.
    /// </summary>
    public RegistrationContactInfo ContactRegistrant 
    {
        get { Initialize(); return _contactRegistrant!; }
        set { Initialize(); AssignOrReplace(ref _contactRegistrant, value); }
    }
    private RegistrationContactInfo? _contactRegistrant;

    /// <summary>
    /// Technical contact.
    /// </summary>
    public RegistrationContactInfo ContactTech 
    {
        get { Initialize(); return _contactTech!; }
        set { Initialize(); AssignOrReplace(ref _contactTech, value); }
    }
    private RegistrationContactInfo? _contactTech;

    /// <summary>
    /// Current DNS type.
    /// </summary>
    public BicepValue<AppServiceDnsType> DnsType 
    {
        get { Initialize(); return _dnsType!; }
        set { Initialize(); _dnsType!.Assign(value); }
    }
    private BicepValue<AppServiceDnsType>? _dnsType;

    /// <summary>
    /// Azure DNS Zone to use.
    /// </summary>
    public BicepValue<string> DnsZoneId 
    {
        get { Initialize(); return _dnsZoneId!; }
        set { Initialize(); _dnsZoneId!.Assign(value); }
    }
    private BicepValue<string>? _dnsZoneId;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if the domain should be automatically
    /// renewed; otherwise, &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsAutoRenew 
    {
        get { Initialize(); return _isAutoRenew!; }
        set { Initialize(); _isAutoRenew!.Assign(value); }
    }
    private BicepValue<bool>? _isAutoRenew;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if domain privacy is enabled for this
    /// domain; otherwise, &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsDomainPrivacyEnabled 
    {
        get { Initialize(); return _isDomainPrivacyEnabled!; }
        set { Initialize(); _isDomainPrivacyEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isDomainPrivacyEnabled;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Target DNS type (would be used for migration).
    /// </summary>
    public BicepValue<AppServiceDnsType> TargetDnsType 
    {
        get { Initialize(); return _targetDnsType!; }
        set { Initialize(); _targetDnsType!.Assign(value); }
    }
    private BicepValue<AppServiceDnsType>? _targetDnsType;

    /// <summary>
    /// Domain creation timestamp.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// Reasons why domain is not renewable.
    /// </summary>
    public BicepList<DomainNotRenewableReason> DomainNotRenewableReasons 
    {
        get { Initialize(); return _domainNotRenewableReasons!; }
    }
    private BicepList<DomainNotRenewableReason>? _domainNotRenewableReasons;

    /// <summary>
    /// Domain expiration timestamp.
    /// </summary>
    public BicepValue<DateTimeOffset> ExpireOn 
    {
        get { Initialize(); return _expireOn!; }
    }
    private BicepValue<DateTimeOffset>? _expireOn;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if Azure can assign this domain to App
    /// Service apps; otherwise, &lt;code&gt;false&lt;/code&gt;. This value
    /// will be &lt;code&gt;true&lt;/code&gt; if domain registration status is
    /// active and              it is hosted on name servers Azure has
    /// programmatic access to.
    /// </summary>
    public BicepValue<bool> IsDnsRecordManagementReady 
    {
        get { Initialize(); return _isDnsRecordManagementReady!; }
    }
    private BicepValue<bool>? _isDnsRecordManagementReady;

    /// <summary>
    /// Timestamp when the domain was renewed last time.
    /// </summary>
    public BicepValue<DateTimeOffset> LastRenewedOn 
    {
        get { Initialize(); return _lastRenewedOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastRenewedOn;

    /// <summary>
    /// All hostnames derived from the domain and assigned to Azure resources.
    /// </summary>
    public BicepList<AppServiceHostName> ManagedHostNames 
    {
        get { Initialize(); return _managedHostNames!; }
    }
    private BicepList<AppServiceHostName>? _managedHostNames;

    /// <summary>
    /// Name servers.
    /// </summary>
    public BicepList<string> NameServers 
    {
        get { Initialize(); return _nameServers!; }
    }
    private BicepList<string>? _nameServers;

    /// <summary>
    /// Domain provisioning state.
    /// </summary>
    public BicepValue<ProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<ProvisioningState>? _provisioningState;

    /// <summary>
    /// Domain registration status.
    /// </summary>
    public BicepValue<AppServiceDomainStatus> RegistrationStatus 
    {
        get { Initialize(); return _registrationStatus!; }
    }
    private BicepValue<AppServiceDomainStatus>? _registrationStatus;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new AppServiceDomain.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the AppServiceDomain resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the AppServiceDomain.</param>
    public AppServiceDomain(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.DomainRegistration/domains", resourceVersion ?? "2024-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppServiceDomain.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _authCode = DefineProperty<string>("AuthCode", ["properties", "authCode"]);
        _consent = DefineModelProperty<DomainPurchaseConsent>("Consent", ["properties", "consent"]);
        _contactAdmin = DefineModelProperty<RegistrationContactInfo>("ContactAdmin", ["properties", "contactAdmin"]);
        _contactBilling = DefineModelProperty<RegistrationContactInfo>("ContactBilling", ["properties", "contactBilling"]);
        _contactRegistrant = DefineModelProperty<RegistrationContactInfo>("ContactRegistrant", ["properties", "contactRegistrant"]);
        _contactTech = DefineModelProperty<RegistrationContactInfo>("ContactTech", ["properties", "contactTech"]);
        _dnsType = DefineProperty<AppServiceDnsType>("DnsType", ["properties", "dnsType"]);
        _dnsZoneId = DefineProperty<string>("DnsZoneId", ["properties", "dnsZoneId"]);
        _isAutoRenew = DefineProperty<bool>("IsAutoRenew", ["properties", "autoRenew"]);
        _isDomainPrivacyEnabled = DefineProperty<bool>("IsDomainPrivacyEnabled", ["properties", "privacy"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _targetDnsType = DefineProperty<AppServiceDnsType>("TargetDnsType", ["properties", "targetDnsType"]);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["properties", "createdTime"], isOutput: true);
        _domainNotRenewableReasons = DefineListProperty<DomainNotRenewableReason>("DomainNotRenewableReasons", ["properties", "domainNotRenewableReasons"], isOutput: true);
        _expireOn = DefineProperty<DateTimeOffset>("ExpireOn", ["properties", "expirationTime"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _isDnsRecordManagementReady = DefineProperty<bool>("IsDnsRecordManagementReady", ["properties", "readyForDnsRecordManagement"], isOutput: true);
        _lastRenewedOn = DefineProperty<DateTimeOffset>("LastRenewedOn", ["properties", "lastRenewedTime"], isOutput: true);
        _managedHostNames = DefineListProperty<AppServiceHostName>("ManagedHostNames", ["properties", "managedHostNames"], isOutput: true);
        _nameServers = DefineListProperty<string>("NameServers", ["properties", "nameServers"], isOutput: true);
        _provisioningState = DefineProperty<ProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _registrationStatus = DefineProperty<AppServiceDomainStatus>("RegistrationStatus", ["properties", "registrationStatus"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported AppServiceDomain resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-04-01.
        /// </summary>
        public static readonly string V2024_04_01 = "2024-04-01";

        /// <summary>
        /// 2023-12-01.
        /// </summary>
        public static readonly string V2023_12_01 = "2023-12-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";

        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-15.
        /// </summary>
        public static readonly string V2021_01_15 = "2021-01-15";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2020-12-01.
        /// </summary>
        public static readonly string V2020_12_01 = "2020-12-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2019-08-01.
        /// </summary>
        public static readonly string V2019_08_01 = "2019-08-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2015-04-01.
        /// </summary>
        public static readonly string V2015_04_01 = "2015-04-01";

        /// <summary>
        /// 2015-02-01.
        /// </summary>
        public static readonly string V2015_02_01 = "2015-02-01";
    }

    /// <summary>
    /// Creates a reference to an existing AppServiceDomain.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the AppServiceDomain resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the AppServiceDomain.</param>
    /// <returns>The existing AppServiceDomain resource.</returns>
    public static AppServiceDomain FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
