// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Built-in AppService roles that you can assign to users, groups, service
/// principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct AppServiceBuiltInRole(string value) : IEquatable<AppServiceBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// Manage the web plans for websites. Does not allow you to assign roles
    /// in Azure RBAC.
    /// </summary>
    public static AppServiceBuiltInRole WebPlanContributor { get; } = new(WebPlanContributorValue);
    internal const string WebPlanContributorValue = "2cc479cb-7b4d-49a8-b449-8c00fd0f0a4b";

    /// <summary>
    /// Manage websites, but not web plans. Does not allow you to assign roles
    /// in Azure RBAC.
    /// </summary>
    public static AppServiceBuiltInRole WebsiteContributor { get; } = new(WebsiteContributorValue);
    internal const string WebsiteContributorValue = "de139f84-1756-47ae-9be6-808fbbe84772";

    /// <summary>
    /// Try to get the name of a built-in AppService role from its ID value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in AppService role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(AppServiceBuiltInRole value) =>
        value._value switch
        {
            WebPlanContributorValue => nameof(WebPlanContributor),
            WebsiteContributorValue => nameof(WebsiteContributor),
            _ => value._value
        };

    /// <summary>
    /// Determines if two AppServiceBuiltInRole values are the same.
    /// </summary>
    /// <param name="left">The first AppServiceBuiltInRole to compare.</param>
    /// <param name="right">The second AppServiceBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(AppServiceBuiltInRole left, AppServiceBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two AppServiceBuiltInRole values are different.
    /// </summary>
    /// <param name="left">The first AppServiceBuiltInRole to compare.</param>
    /// <param name="right">The second AppServiceBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(AppServiceBuiltInRole left, AppServiceBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a AppServiceBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator AppServiceBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is AppServiceBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(AppServiceBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
