// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.AppService;

/// <summary>
/// AppCertificate.
/// </summary>
public partial class AppCertificate : ProvisionableResource
{
    /// <summary>
    /// Name of the certificate.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// CNAME of the certificate to be issued via free certificate.
    /// </summary>
    public BicepValue<string> CanonicalName 
    {
        get { Initialize(); return _canonicalName!; }
        set { Initialize(); _canonicalName!.Assign(value); }
    }
    private BicepValue<string>? _canonicalName;

    /// <summary>
    /// Method of domain validation for free cert.
    /// </summary>
    public BicepValue<string> DomainValidationMethod 
    {
        get { Initialize(); return _domainValidationMethod!; }
        set { Initialize(); _domainValidationMethod!.Assign(value); }
    }
    private BicepValue<string>? _domainValidationMethod;

    /// <summary>
    /// Host names the certificate applies to.
    /// </summary>
    public BicepList<string> HostNames 
    {
        get { Initialize(); return _hostNames!; }
        set { Initialize(); _hostNames!.Assign(value); }
    }
    private BicepList<string>? _hostNames;

    /// <summary>
    /// Key Vault Csm resource Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> KeyVaultId 
    {
        get { Initialize(); return _keyVaultId!; }
        set { Initialize(); _keyVaultId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _keyVaultId;

    /// <summary>
    /// Key Vault secret name.
    /// </summary>
    public BicepValue<string> KeyVaultSecretName 
    {
        get { Initialize(); return _keyVaultSecretName!; }
        set { Initialize(); _keyVaultSecretName!.Assign(value); }
    }
    private BicepValue<string>? _keyVaultSecretName;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Certificate password.
    /// </summary>
    public BicepValue<string> Password 
    {
        get { Initialize(); return _password!; }
        set { Initialize(); _password!.Assign(value); }
    }
    private BicepValue<string>? _password;

    /// <summary>
    /// Pfx blob.
    /// </summary>
    public BicepValue<BinaryData> PfxBlob 
    {
        get { Initialize(); return _pfxBlob!; }
        set { Initialize(); _pfxBlob!.Assign(value); }
    }
    private BicepValue<BinaryData>? _pfxBlob;

    /// <summary>
    /// Resource ID of the associated App Service plan, formatted as:
    /// &quot;/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}&quot;.
    /// </summary>
    public BicepValue<ResourceIdentifier> ServerFarmId 
    {
        get { Initialize(); return _serverFarmId!; }
        set { Initialize(); _serverFarmId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _serverFarmId;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Raw bytes of .cer file.
    /// </summary>
    public BicepValue<BinaryData> CerBlob 
    {
        get { Initialize(); return _cerBlob!; }
    }
    private BicepValue<BinaryData>? _cerBlob;

    /// <summary>
    /// Certificate expiration date.
    /// </summary>
    public BicepValue<DateTimeOffset> ExpireOn 
    {
        get { Initialize(); return _expireOn!; }
    }
    private BicepValue<DateTimeOffset>? _expireOn;

    /// <summary>
    /// Friendly name of the certificate.
    /// </summary>
    public BicepValue<string> FriendlyName 
    {
        get { Initialize(); return _friendlyName!; }
    }
    private BicepValue<string>? _friendlyName;

    /// <summary>
    /// Specification for the App Service Environment to use for the
    /// certificate.
    /// </summary>
    public HostingEnvironmentProfile HostingEnvironmentProfile 
    {
        get { Initialize(); return _hostingEnvironmentProfile!; }
    }
    private HostingEnvironmentProfile? _hostingEnvironmentProfile;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Certificate issue Date.
    /// </summary>
    public BicepValue<DateTimeOffset> IssueOn 
    {
        get { Initialize(); return _issueOn!; }
    }
    private BicepValue<DateTimeOffset>? _issueOn;

    /// <summary>
    /// Certificate issuer.
    /// </summary>
    public BicepValue<string> Issuer 
    {
        get { Initialize(); return _issuer!; }
    }
    private BicepValue<string>? _issuer;

    /// <summary>
    /// Is the certificate valid?.
    /// </summary>
    public BicepValue<bool> IsValid 
    {
        get { Initialize(); return _isValid!; }
    }
    private BicepValue<bool>? _isValid;

    /// <summary>
    /// Status of the Key Vault secret.
    /// </summary>
    public BicepValue<KeyVaultSecretStatus> KeyVaultSecretStatus 
    {
        get { Initialize(); return _keyVaultSecretStatus!; }
    }
    private BicepValue<KeyVaultSecretStatus>? _keyVaultSecretStatus;

    /// <summary>
    /// Public key hash.
    /// </summary>
    public BicepValue<string> PublicKeyHash 
    {
        get { Initialize(); return _publicKeyHash!; }
    }
    private BicepValue<string>? _publicKeyHash;

    /// <summary>
    /// Self link.
    /// </summary>
    public BicepValue<string> SelfLink 
    {
        get { Initialize(); return _selfLink!; }
    }
    private BicepValue<string>? _selfLink;

    /// <summary>
    /// App name.
    /// </summary>
    public BicepValue<string> SiteName 
    {
        get { Initialize(); return _siteName!; }
    }
    private BicepValue<string>? _siteName;

    /// <summary>
    /// Subject name of the certificate.
    /// </summary>
    public BicepValue<string> SubjectName 
    {
        get { Initialize(); return _subjectName!; }
    }
    private BicepValue<string>? _subjectName;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Certificate thumbprint.
    /// </summary>
    public BicepValue<string> ThumbprintString 
    {
        get { Initialize(); return _thumbprintString!; }
    }
    private BicepValue<string>? _thumbprintString;

    /// <summary>
    /// Creates a new AppCertificate.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the AppCertificate resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the AppCertificate.</param>
    public AppCertificate(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Web/certificates", resourceVersion ?? "2024-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppCertificate.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _canonicalName = DefineProperty<string>("CanonicalName", ["properties", "canonicalName"]);
        _domainValidationMethod = DefineProperty<string>("DomainValidationMethod", ["properties", "domainValidationMethod"]);
        _hostNames = DefineListProperty<string>("HostNames", ["properties", "hostNames"]);
        _keyVaultId = DefineProperty<ResourceIdentifier>("KeyVaultId", ["properties", "keyVaultId"]);
        _keyVaultSecretName = DefineProperty<string>("KeyVaultSecretName", ["properties", "keyVaultSecretName"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _password = DefineProperty<string>("Password", ["properties", "password"]);
        _pfxBlob = DefineProperty<BinaryData>("PfxBlob", ["properties", "pfxBlob"]);
        _serverFarmId = DefineProperty<ResourceIdentifier>("ServerFarmId", ["properties", "serverFarmId"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _cerBlob = DefineProperty<BinaryData>("CerBlob", ["properties", "cerBlob"], isOutput: true);
        _expireOn = DefineProperty<DateTimeOffset>("ExpireOn", ["properties", "expirationDate"], isOutput: true);
        _friendlyName = DefineProperty<string>("FriendlyName", ["properties", "friendlyName"], isOutput: true);
        _hostingEnvironmentProfile = DefineModelProperty<HostingEnvironmentProfile>("HostingEnvironmentProfile", ["properties", "hostingEnvironmentProfile"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _issueOn = DefineProperty<DateTimeOffset>("IssueOn", ["properties", "issueDate"], isOutput: true);
        _issuer = DefineProperty<string>("Issuer", ["properties", "issuer"], isOutput: true);
        _isValid = DefineProperty<bool>("IsValid", ["properties", "valid"], isOutput: true);
        _keyVaultSecretStatus = DefineProperty<KeyVaultSecretStatus>("KeyVaultSecretStatus", ["properties", "keyVaultSecretStatus"], isOutput: true);
        _publicKeyHash = DefineProperty<string>("PublicKeyHash", ["properties", "publicKeyHash"], isOutput: true);
        _selfLink = DefineProperty<string>("SelfLink", ["properties", "selfLink"], isOutput: true);
        _siteName = DefineProperty<string>("SiteName", ["properties", "siteName"], isOutput: true);
        _subjectName = DefineProperty<string>("SubjectName", ["properties", "subjectName"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _thumbprintString = DefineProperty<string>("ThumbprintString", ["properties", "thumbprint"], isOutput: true);
    }

    /// <summary>
    /// Supported AppCertificate resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-04-01.
        /// </summary>
        public static readonly string V2024_04_01 = "2024-04-01";

        /// <summary>
        /// 2023-12-01.
        /// </summary>
        public static readonly string V2023_12_01 = "2023-12-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";

        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-15.
        /// </summary>
        public static readonly string V2021_01_15 = "2021-01-15";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2020-12-01.
        /// </summary>
        public static readonly string V2020_12_01 = "2020-12-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2019-08-01.
        /// </summary>
        public static readonly string V2019_08_01 = "2019-08-01";

        /// <summary>
        /// 2018-11-01.
        /// </summary>
        public static readonly string V2018_11_01 = "2018-11-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2016-03-01.
        /// </summary>
        public static readonly string V2016_03_01 = "2016-03-01";

        /// <summary>
        /// 2015-08-01.
        /// </summary>
        public static readonly string V2015_08_01 = "2015-08-01";

        /// <summary>
        /// 2015-07-01.
        /// </summary>
        public static readonly string V2015_07_01 = "2015-07-01";

        /// <summary>
        /// 2015-06-01.
        /// </summary>
        public static readonly string V2015_06_01 = "2015-06-01";

        /// <summary>
        /// 2015-05-01.
        /// </summary>
        public static readonly string V2015_05_01 = "2015-05-01";

        /// <summary>
        /// 2015-04-01.
        /// </summary>
        public static readonly string V2015_04_01 = "2015-04-01";

        /// <summary>
        /// 2015-02-01.
        /// </summary>
        public static readonly string V2015_02_01 = "2015-02-01";

        /// <summary>
        /// 2014-11-01.
        /// </summary>
        public static readonly string V2014_11_01 = "2014-11-01";

        /// <summary>
        /// 2014-06-01.
        /// </summary>
        public static readonly string V2014_06_01 = "2014-06-01";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";
    }

    /// <summary>
    /// Creates a reference to an existing AppCertificate.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the AppCertificate resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the AppCertificate.</param>
    /// <returns>The existing AppCertificate resource.</returns>
    public static AppCertificate FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this AppCertificate resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 260, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen | ResourceNameCharacters.Underscore | ResourceNameCharacters.Period);
}
