// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Secret to be added to volume.
/// </summary>
public partial class SecretVolumeItem : ProvisionableConstruct
{
    /// <summary>
    /// Name of the Container App secret from which to pull the secret value.
    /// </summary>
    public BicepValue<string> SecretRef 
    {
        get { Initialize(); return _secretRef!; }
        set { Initialize(); _secretRef!.Assign(value); }
    }
    private BicepValue<string>? _secretRef;

    /// <summary>
    /// Path to project secret to. If no path is provided, path defaults to
    /// name of secret listed in secretRef.
    /// </summary>
    public BicepValue<string> Path 
    {
        get { Initialize(); return _path!; }
        set { Initialize(); _path!.Assign(value); }
    }
    private BicepValue<string>? _path;

    /// <summary>
    /// Creates a new SecretVolumeItem.
    /// </summary>
    public SecretVolumeItem()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SecretVolumeItem.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _secretRef = DefineProperty<string>("SecretRef", ["secretRef"]);
        _path = DefineProperty<string>("Path", ["path"]);
    }
}
