// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Certificate resource specific properties.
/// </summary>
public partial class ManagedCertificateProperties : ProvisionableConstruct
{
    /// <summary>
    /// Provisioning state of the certificate.
    /// </summary>
    public BicepValue<ContainerAppCertificateProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<ContainerAppCertificateProvisioningState>? _provisioningState;

    /// <summary>
    /// Subject name of the certificate.
    /// </summary>
    public BicepValue<string> SubjectName 
    {
        get { Initialize(); return _subjectName!; }
        set { Initialize(); _subjectName!.Assign(value); }
    }
    private BicepValue<string>? _subjectName;

    /// <summary>
    /// Any error occurred during the certificate provision.
    /// </summary>
    public BicepValue<string> Error 
    {
        get { Initialize(); return _error!; }
    }
    private BicepValue<string>? _error;

    /// <summary>
    /// Selected type of domain control validation for managed certificates.
    /// </summary>
    public BicepValue<ManagedCertificateDomainControlValidation> DomainControlValidation 
    {
        get { Initialize(); return _domainControlValidation!; }
        set { Initialize(); _domainControlValidation!.Assign(value); }
    }
    private BicepValue<ManagedCertificateDomainControlValidation>? _domainControlValidation;

    /// <summary>
    /// A TXT token used for DNS TXT domain control validation when issuing
    /// this type of managed certificates.
    /// </summary>
    public BicepValue<string> ValidationToken 
    {
        get { Initialize(); return _validationToken!; }
    }
    private BicepValue<string>? _validationToken;

    /// <summary>
    /// Creates a new ManagedCertificateProperties.
    /// </summary>
    public ManagedCertificateProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagedCertificateProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _provisioningState = DefineProperty<ContainerAppCertificateProvisioningState>("ProvisioningState", ["provisioningState"], isOutput: true);
        _subjectName = DefineProperty<string>("SubjectName", ["subjectName"]);
        _error = DefineProperty<string>("Error", ["error"], isOutput: true);
        _domainControlValidation = DefineProperty<ManagedCertificateDomainControlValidation>("DomainControlValidation", ["domainControlValidation"]);
        _validationToken = DefineProperty<string>("ValidationToken", ["validationToken"], isOutput: true);
    }
}
