// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Cron formatted repeating trigger schedule (&quot;* * * * *&quot;) for
/// cronjobs. Properties completions and parallelism would be set to 1 by
/// default.
/// </summary>
public partial class JobConfigurationScheduleTriggerConfig : ProvisionableConstruct
{
    /// <summary>
    /// Minimum number of successful replica completions before overall job
    /// completion.
    /// </summary>
    public BicepValue<int> ReplicaCompletionCount 
    {
        get { Initialize(); return _replicaCompletionCount!; }
        set { Initialize(); _replicaCompletionCount!.Assign(value); }
    }
    private BicepValue<int>? _replicaCompletionCount;

    /// <summary>
    /// Cron formatted repeating schedule (&quot;* * * * *&quot;) of a Cron Job.
    /// </summary>
    public BicepValue<string> CronExpression 
    {
        get { Initialize(); return _cronExpression!; }
        set { Initialize(); _cronExpression!.Assign(value); }
    }
    private BicepValue<string>? _cronExpression;

    /// <summary>
    /// Number of parallel replicas of a job that can run at a given time.
    /// </summary>
    public BicepValue<int> Parallelism 
    {
        get { Initialize(); return _parallelism!; }
        set { Initialize(); _parallelism!.Assign(value); }
    }
    private BicepValue<int>? _parallelism;

    /// <summary>
    /// Creates a new JobConfigurationScheduleTriggerConfig.
    /// </summary>
    public JobConfigurationScheduleTriggerConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// JobConfigurationScheduleTriggerConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _replicaCompletionCount = DefineProperty<int>("ReplicaCompletionCount", ["replicaCompletionCount"]);
        _cronExpression = DefineProperty<string>("CronExpression", ["cronExpression"]);
        _parallelism = DefineProperty<int>("Parallelism", ["parallelism"]);
    }
}
