// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Manual trigger configuration for a single execution job. Properties
/// replicaCompletionCount and parallelism would be set to 1 by default.
/// </summary>
public partial class JobConfigurationManualTriggerConfig : ProvisionableConstruct
{
    /// <summary>
    /// Minimum number of successful replica completions before overall job
    /// completion.
    /// </summary>
    public BicepValue<int> ReplicaCompletionCount 
    {
        get { Initialize(); return _replicaCompletionCount!; }
        set { Initialize(); _replicaCompletionCount!.Assign(value); }
    }
    private BicepValue<int>? _replicaCompletionCount;

    /// <summary>
    /// Number of parallel replicas of a job that can run at a given time.
    /// </summary>
    public BicepValue<int> Parallelism 
    {
        get { Initialize(); return _parallelism!; }
        set { Initialize(); _parallelism!.Assign(value); }
    }
    private BicepValue<int>? _parallelism;

    /// <summary>
    /// Creates a new JobConfigurationManualTriggerConfig.
    /// </summary>
    public JobConfigurationManualTriggerConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// JobConfigurationManualTriggerConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _replicaCompletionCount = DefineProperty<int>("ReplicaCompletionCount", ["replicaCompletionCount"]);
        _parallelism = DefineProperty<int>("Parallelism", ["parallelism"]);
    }
}
