// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Port mappings of container app ingress.
/// </summary>
public partial class IngressPortMapping : ProvisionableConstruct
{
    /// <summary>
    /// Specifies whether the app port is accessible outside of the environment.
    /// </summary>
    public BicepValue<bool> External 
    {
        get { Initialize(); return _external!; }
        set { Initialize(); _external!.Assign(value); }
    }
    private BicepValue<bool>? _external;

    /// <summary>
    /// Specifies the port user&apos;s container listens on.
    /// </summary>
    public BicepValue<int> TargetPort 
    {
        get { Initialize(); return _targetPort!; }
        set { Initialize(); _targetPort!.Assign(value); }
    }
    private BicepValue<int>? _targetPort;

    /// <summary>
    /// Specifies the exposed port for the target port. If not specified, it
    /// defaults to target port.
    /// </summary>
    public BicepValue<int> ExposedPort 
    {
        get { Initialize(); return _exposedPort!; }
        set { Initialize(); _exposedPort!.Assign(value); }
    }
    private BicepValue<int>? _exposedPort;

    /// <summary>
    /// Creates a new IngressPortMapping.
    /// </summary>
    public IngressPortMapping()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of IngressPortMapping.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _external = DefineProperty<bool>("External", ["external"]);
        _targetPort = DefineProperty<int>("TargetPort", ["targetPort"]);
        _exposedPort = DefineProperty<int>("ExposedPort", ["exposedPort"]);
    }
}
