// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the secrets references of encryption key and
/// signing key for ContainerApp Service Authentication/Authorization.
/// </summary>
public partial class EncryptionSettings : ProvisionableConstruct
{
    /// <summary>
    /// The secret name which is referenced for EncryptionKey.
    /// </summary>
    public BicepValue<string> ContainerAppAuthEncryptionSecretName 
    {
        get { Initialize(); return _containerAppAuthEncryptionSecretName!; }
        set { Initialize(); _containerAppAuthEncryptionSecretName!.Assign(value); }
    }
    private BicepValue<string>? _containerAppAuthEncryptionSecretName;

    /// <summary>
    /// The secret name which is referenced for SigningKey.
    /// </summary>
    public BicepValue<string> ContainerAppAuthSigningSecretName 
    {
        get { Initialize(); return _containerAppAuthSigningSecretName!; }
        set { Initialize(); _containerAppAuthSigningSecretName!.Assign(value); }
    }
    private BicepValue<string>? _containerAppAuthSigningSecretName;

    /// <summary>
    /// Creates a new EncryptionSettings.
    /// </summary>
    public EncryptionSettings()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of EncryptionSettings.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _containerAppAuthEncryptionSecretName = DefineProperty<string>("ContainerAppAuthEncryptionSecretName", ["containerAppAuthEncryptionSecretName"]);
        _containerAppAuthSigningSecretName = DefineProperty<string>("ContainerAppAuthSigningSecretName", ["containerAppAuthSigningSecretName"]);
    }
}
