// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Workload profile to scope container app execution.
/// </summary>
public partial class ContainerAppWorkloadProfile : ProvisionableConstruct
{
    /// <summary>
    /// Workload profile type for the workloads to run on.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Workload profile type for the workloads to run on.
    /// </summary>
    public BicepValue<string> WorkloadProfileType 
    {
        get { Initialize(); return _workloadProfileType!; }
        set { Initialize(); _workloadProfileType!.Assign(value); }
    }
    private BicepValue<string>? _workloadProfileType;

    /// <summary>
    /// The minimum capacity.
    /// </summary>
    public BicepValue<int> MinimumNodeCount 
    {
        get { Initialize(); return _minimumNodeCount!; }
        set { Initialize(); _minimumNodeCount!.Assign(value); }
    }
    private BicepValue<int>? _minimumNodeCount;

    /// <summary>
    /// The maximum capacity.
    /// </summary>
    public BicepValue<int> MaximumNodeCount 
    {
        get { Initialize(); return _maximumNodeCount!; }
        set { Initialize(); _maximumNodeCount!.Assign(value); }
    }
    private BicepValue<int>? _maximumNodeCount;

    /// <summary>
    /// Creates a new ContainerAppWorkloadProfile.
    /// </summary>
    public ContainerAppWorkloadProfile()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppWorkloadProfile.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _workloadProfileType = DefineProperty<string>("WorkloadProfileType", ["workloadProfileType"]);
        _minimumNodeCount = DefineProperty<int>("MinimumNodeCount", ["minimumCount"]);
        _maximumNodeCount = DefineProperty<int>("MaximumNodeCount", ["maximumCount"]);
    }
}
