// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Volume mount for the Container App.
/// </summary>
public partial class ContainerAppVolumeMount : ProvisionableConstruct
{
    /// <summary>
    /// This must match the Name of a Volume.
    /// </summary>
    public BicepValue<string> VolumeName 
    {
        get { Initialize(); return _volumeName!; }
        set { Initialize(); _volumeName!.Assign(value); }
    }
    private BicepValue<string>? _volumeName;

    /// <summary>
    /// Path within the container at which the volume should be mounted.Must
    /// not contain &apos;:&apos;.
    /// </summary>
    public BicepValue<string> MountPath 
    {
        get { Initialize(); return _mountPath!; }
        set { Initialize(); _mountPath!.Assign(value); }
    }
    private BicepValue<string>? _mountPath;

    /// <summary>
    /// Path within the volume from which the container&apos;s volume should be
    /// mounted. Defaults to &quot;&quot; (volume&apos;s root).
    /// </summary>
    public BicepValue<string> SubPath 
    {
        get { Initialize(); return _subPath!; }
        set { Initialize(); _subPath!.Assign(value); }
    }
    private BicepValue<string>? _subPath;

    /// <summary>
    /// Creates a new ContainerAppVolumeMount.
    /// </summary>
    public ContainerAppVolumeMount()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppVolumeMount.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _volumeName = DefineProperty<string>("VolumeName", ["volumeName"]);
        _mountPath = DefineProperty<string>("MountPath", ["mountPath"]);
        _subPath = DefineProperty<string>("SubPath", ["subPath"]);
    }
}
