// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Configuration properties for apps environment to join a Virtual Network.
/// </summary>
public partial class ContainerAppVnetConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Boolean indicating the environment only has an internal load balancer.
    /// These environments do not have a public static IP resource. They must
    /// provide infrastructureSubnetId if enabling this property.
    /// </summary>
    public BicepValue<bool> IsInternal 
    {
        get { Initialize(); return _isInternal!; }
        set { Initialize(); _isInternal!.Assign(value); }
    }
    private BicepValue<bool>? _isInternal;

    /// <summary>
    /// Resource ID of a subnet for infrastructure components. Must not overlap
    /// with any other provided IP ranges.
    /// </summary>
    public BicepValue<ResourceIdentifier> InfrastructureSubnetId 
    {
        get { Initialize(); return _infrastructureSubnetId!; }
        set { Initialize(); _infrastructureSubnetId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _infrastructureSubnetId;

    /// <summary>
    /// CIDR notation IP range assigned to the Docker bridge, network. Must not
    /// overlap with any other provided IP ranges.
    /// </summary>
    public BicepValue<string> DockerBridgeCidr 
    {
        get { Initialize(); return _dockerBridgeCidr!; }
        set { Initialize(); _dockerBridgeCidr!.Assign(value); }
    }
    private BicepValue<string>? _dockerBridgeCidr;

    /// <summary>
    /// IP range in CIDR notation that can be reserved for environment
    /// infrastructure IP addresses. Must not overlap with any other provided
    /// IP ranges.
    /// </summary>
    public BicepValue<string> PlatformReservedCidr 
    {
        get { Initialize(); return _platformReservedCidr!; }
        set { Initialize(); _platformReservedCidr!.Assign(value); }
    }
    private BicepValue<string>? _platformReservedCidr;

    /// <summary>
    /// An IP address from the IP range defined by platformReservedCidr that
    /// will be reserved for the internal DNS server.
    /// </summary>
    public BicepValue<string> PlatformReservedDnsIP 
    {
        get { Initialize(); return _platformReservedDnsIP!; }
        set { Initialize(); _platformReservedDnsIP!.Assign(value); }
    }
    private BicepValue<string>? _platformReservedDnsIP;

    /// <summary>
    /// Creates a new ContainerAppVnetConfiguration.
    /// </summary>
    public ContainerAppVnetConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppVnetConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isInternal = DefineProperty<bool>("IsInternal", ["internal"]);
        _infrastructureSubnetId = DefineProperty<ResourceIdentifier>("InfrastructureSubnetId", ["infrastructureSubnetId"]);
        _dockerBridgeCidr = DefineProperty<string>("DockerBridgeCidr", ["dockerBridgeCidr"]);
        _platformReservedCidr = DefineProperty<string>("PlatformReservedCidr", ["platformReservedCidr"]);
        _platformReservedDnsIP = DefineProperty<string>("PlatformReservedDnsIP", ["platformReservedDnsIP"]);
    }
}
