// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the app registration for the Twitter provider.
/// </summary>
public partial class ContainerAppTwitterRegistration : ProvisionableConstruct
{
    /// <summary>
    /// The OAuth 1.0a consumer key of the Twitter application used for
    /// sign-in.             This setting is required for enabling Twitter
    /// Sign-In.             Twitter Sign-In documentation:
    /// https://dev.twitter.com/web/sign-in
    /// </summary>
    public BicepValue<string> ConsumerKey 
    {
        get { Initialize(); return _consumerKey!; }
        set { Initialize(); _consumerKey!.Assign(value); }
    }
    private BicepValue<string>? _consumerKey;

    /// <summary>
    /// The app setting name that contains the OAuth 1.0a consumer secret of
    /// the Twitter             application used for sign-in.
    /// </summary>
    public BicepValue<string> ConsumerSecretSettingName 
    {
        get { Initialize(); return _consumerSecretSettingName!; }
        set { Initialize(); _consumerSecretSettingName!.Assign(value); }
    }
    private BicepValue<string>? _consumerSecretSettingName;

    /// <summary>
    /// Creates a new ContainerAppTwitterRegistration.
    /// </summary>
    public ContainerAppTwitterRegistration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppTwitterRegistration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _consumerKey = DefineProperty<string>("ConsumerKey", ["consumerKey"]);
        _consumerSecretSettingName = DefineProperty<string>("ConsumerSecretSettingName", ["consumerSecretSettingName"]);
    }
}
