// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the Twitter provider.
/// </summary>
public partial class ContainerAppTwitterConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// &lt;code&gt;false&lt;/code&gt; if the Twitter provider should not be
    /// enabled despite the set registration; otherwise,
    /// &lt;code&gt;true&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// The configuration settings of the app registration for the Twitter
    /// provider.
    /// </summary>
    public ContainerAppTwitterRegistration Registration 
    {
        get { Initialize(); return _registration!; }
        set { Initialize(); AssignOrReplace(ref _registration, value); }
    }
    private ContainerAppTwitterRegistration? _registration;

    /// <summary>
    /// Creates a new ContainerAppTwitterConfiguration.
    /// </summary>
    public ContainerAppTwitterConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppTwitterConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _registration = DefineModelProperty<ContainerAppTwitterRegistration>("Registration", ["registration"]);
    }
}
