// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the token store.
/// </summary>
public partial class ContainerAppTokenStore : ProvisionableConstruct
{
    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; to durably store platform-specific
    /// security tokens that are obtained during login flows; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.              The default is
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// The number of hours after session token expiration that a session token
    /// can be used to             call the token refresh API. The default is
    /// 72 hours.
    /// </summary>
    public BicepValue<double> TokenRefreshExtensionHours 
    {
        get { Initialize(); return _tokenRefreshExtensionHours!; }
        set { Initialize(); _tokenRefreshExtensionHours!.Assign(value); }
    }
    private BicepValue<double>? _tokenRefreshExtensionHours;

    /// <summary>
    /// The name of the app secrets containing the SAS URL of the blob storage
    /// containing the tokens.
    /// </summary>
    public BicepValue<string> AzureBlobStorageSasUrlSettingName 
    {
        get { Initialize(); return _azureBlobStorageSasUrlSettingName!; }
        set { Initialize(); _azureBlobStorageSasUrlSettingName!.Assign(value); }
    }
    private BicepValue<string>? _azureBlobStorageSasUrlSettingName;

    /// <summary>
    /// Creates a new ContainerAppTokenStore.
    /// </summary>
    public ContainerAppTokenStore()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppTokenStore.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _tokenRefreshExtensionHours = DefineProperty<double>("TokenRefreshExtensionHours", ["tokenRefreshExtensionHours"]);
        _azureBlobStorageSasUrlSettingName = DefineProperty<string>("AzureBlobStorageSasUrlSettingName", ["azureBlobStorage", "sasUrlSettingName"]);
    }
}
