// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Container App versioned application definition.             Defines the
/// desired state of an immutable revision.             Any changes to this
/// section Will result in a new revision being created
/// </summary>
public partial class ContainerAppTemplate : ProvisionableConstruct
{
    /// <summary>
    /// User friendly suffix that is appended to the revision name.
    /// </summary>
    public BicepValue<string> RevisionSuffix 
    {
        get { Initialize(); return _revisionSuffix!; }
        set { Initialize(); _revisionSuffix!.Assign(value); }
    }
    private BicepValue<string>? _revisionSuffix;

    /// <summary>
    /// Optional duration in seconds the Container App Instance needs to
    /// terminate gracefully. Value must be non-negative integer. The value
    /// zero indicates stop immediately via the kill signal (no opportunity to
    /// shut down). If this value is nil, the default grace period will be
    /// used instead. Set this value longer than the expected cleanup time for
    /// your process. Defaults to 30 seconds.
    /// </summary>
    public BicepValue<long> TerminationGracePeriodSeconds 
    {
        get { Initialize(); return _terminationGracePeriodSeconds!; }
        set { Initialize(); _terminationGracePeriodSeconds!.Assign(value); }
    }
    private BicepValue<long>? _terminationGracePeriodSeconds;

    /// <summary>
    /// List of specialized containers that run before app containers.
    /// </summary>
    public BicepList<ContainerAppInitContainer> InitContainers 
    {
        get { Initialize(); return _initContainers!; }
        set { Initialize(); _initContainers!.Assign(value); }
    }
    private BicepList<ContainerAppInitContainer>? _initContainers;

    /// <summary>
    /// List of container definitions for the Container App.
    /// </summary>
    public BicepList<ContainerAppContainer> Containers 
    {
        get { Initialize(); return _containers!; }
        set { Initialize(); _containers!.Assign(value); }
    }
    private BicepList<ContainerAppContainer>? _containers;

    /// <summary>
    /// Scaling properties for the Container App.
    /// </summary>
    public ContainerAppScale Scale 
    {
        get { Initialize(); return _scale!; }
        set { Initialize(); AssignOrReplace(ref _scale, value); }
    }
    private ContainerAppScale? _scale;

    /// <summary>
    /// List of volume definitions for the Container App.
    /// </summary>
    public BicepList<ContainerAppVolume> Volumes 
    {
        get { Initialize(); return _volumes!; }
        set { Initialize(); _volumes!.Assign(value); }
    }
    private BicepList<ContainerAppVolume>? _volumes;

    /// <summary>
    /// List of container app services bound to the app.
    /// </summary>
    public BicepList<ContainerAppServiceBind> ServiceBinds 
    {
        get { Initialize(); return _serviceBinds!; }
        set { Initialize(); _serviceBinds!.Assign(value); }
    }
    private BicepList<ContainerAppServiceBind>? _serviceBinds;

    /// <summary>
    /// Creates a new ContainerAppTemplate.
    /// </summary>
    public ContainerAppTemplate()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppTemplate.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _revisionSuffix = DefineProperty<string>("RevisionSuffix", ["revisionSuffix"]);
        _terminationGracePeriodSeconds = DefineProperty<long>("TerminationGracePeriodSeconds", ["terminationGracePeriodSeconds"]);
        _initContainers = DefineListProperty<ContainerAppInitContainer>("InitContainers", ["initContainers"]);
        _containers = DefineListProperty<ContainerAppContainer>("Containers", ["containers"]);
        _scale = DefineModelProperty<ContainerAppScale>("Scale", ["scale"]);
        _volumes = DefineListProperty<ContainerAppVolume>("Volumes", ["volumes"]);
        _serviceBinds = DefineListProperty<ContainerAppServiceBind>("ServiceBinds", ["serviceBinds"]);
    }
}
