// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// TCPSocket specifies an action involving a TCP port. TCP hooks not yet
/// supported.
/// </summary>
public partial class ContainerAppTcpSocketRequestInfo : ProvisionableConstruct
{
    /// <summary>
    /// Optional: Host name to connect to, defaults to the pod IP.
    /// </summary>
    public BicepValue<string> Host 
    {
        get { Initialize(); return _host!; }
        set { Initialize(); _host!.Assign(value); }
    }
    private BicepValue<string>? _host;

    /// <summary>
    /// Number or name of the port to access on the container. Number must be
    /// in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    /// </summary>
    public BicepValue<int> Port 
    {
        get { Initialize(); return _port!; }
        set { Initialize(); _port!.Assign(value); }
    }
    private BicepValue<int>? _port;

    /// <summary>
    /// Creates a new ContainerAppTcpSocketRequestInfo.
    /// </summary>
    public ContainerAppTcpSocketRequestInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppTcpSocketRequestInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _host = DefineProperty<string>("Host", ["host"]);
        _port = DefineProperty<int>("Port", ["port"]);
    }
}
