// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Configuration to bind a ContainerApp to a dev ContainerApp Service.
/// </summary>
public partial class ContainerAppServiceBind : ProvisionableConstruct
{
    /// <summary>
    /// Resource id of the target service.
    /// </summary>
    public BicepValue<ResourceIdentifier> ServiceId 
    {
        get { Initialize(); return _serviceId!; }
        set { Initialize(); _serviceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _serviceId;

    /// <summary>
    /// Name of the service bind.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Creates a new ContainerAppServiceBind.
    /// </summary>
    public ContainerAppServiceBind()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppServiceBind.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _serviceId = DefineProperty<ResourceIdentifier>("ServiceId", ["serviceId"]);
        _name = DefineProperty<string>("Name", ["name"]);
    }
}
