// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Auth Secrets for Scale Rule.
/// </summary>
public partial class ContainerAppScaleRuleAuth : ProvisionableConstruct
{
    /// <summary>
    /// Name of the secret from which to pull the auth params.
    /// </summary>
    public BicepValue<string> SecretRef 
    {
        get { Initialize(); return _secretRef!; }
        set { Initialize(); _secretRef!.Assign(value); }
    }
    private BicepValue<string>? _secretRef;

    /// <summary>
    /// Trigger Parameter that uses the secret.
    /// </summary>
    public BicepValue<string> TriggerParameter 
    {
        get { Initialize(); return _triggerParameter!; }
        set { Initialize(); _triggerParameter!.Assign(value); }
    }
    private BicepValue<string>? _triggerParameter;

    /// <summary>
    /// Creates a new ContainerAppScaleRuleAuth.
    /// </summary>
    public ContainerAppScaleRuleAuth()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppScaleRuleAuth.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _secretRef = DefineProperty<string>("SecretRef", ["secretRef"]);
        _triggerParameter = DefineProperty<string>("TriggerParameter", ["triggerParameter"]);
    }
}
