// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Container App scaling configurations.
/// </summary>
public partial class ContainerAppScale : ProvisionableConstruct
{
    /// <summary>
    /// Optional. Minimum number of container replicas.
    /// </summary>
    public BicepValue<int> MinReplicas 
    {
        get { Initialize(); return _minReplicas!; }
        set { Initialize(); _minReplicas!.Assign(value); }
    }
    private BicepValue<int>? _minReplicas;

    /// <summary>
    /// Optional. Maximum number of container replicas. Defaults to 10 if not
    /// set.
    /// </summary>
    public BicepValue<int> MaxReplicas 
    {
        get { Initialize(); return _maxReplicas!; }
        set { Initialize(); _maxReplicas!.Assign(value); }
    }
    private BicepValue<int>? _maxReplicas;

    /// <summary>
    /// Scaling rules.
    /// </summary>
    public BicepList<ContainerAppScaleRule> Rules 
    {
        get { Initialize(); return _rules!; }
        set { Initialize(); _rules!.Assign(value); }
    }
    private BicepList<ContainerAppScaleRule>? _rules;

    /// <summary>
    /// Creates a new ContainerAppScale.
    /// </summary>
    public ContainerAppScale()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppScale.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _minReplicas = DefineProperty<int>("MinReplicas", ["minReplicas"]);
        _maxReplicas = DefineProperty<int>("MaxReplicas", ["maxReplicas"]);
        _rules = DefineListProperty<ContainerAppScaleRule>("Rules", ["rules"]);
    }
}
