// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Traffic weight assigned to a revision.
/// </summary>
public partial class ContainerAppRevisionTrafficWeight : ProvisionableConstruct
{
    /// <summary>
    /// Name of a revision.
    /// </summary>
    public BicepValue<string> RevisionName 
    {
        get { Initialize(); return _revisionName!; }
        set { Initialize(); _revisionName!.Assign(value); }
    }
    private BicepValue<string>? _revisionName;

    /// <summary>
    /// Traffic weight assigned to a revision.
    /// </summary>
    public BicepValue<int> Weight 
    {
        get { Initialize(); return _weight!; }
        set { Initialize(); _weight!.Assign(value); }
    }
    private BicepValue<int>? _weight;

    /// <summary>
    /// Indicates that the traffic weight belongs to a latest stable revision.
    /// </summary>
    public BicepValue<bool> IsLatestRevision 
    {
        get { Initialize(); return _isLatestRevision!; }
        set { Initialize(); _isLatestRevision!.Assign(value); }
    }
    private BicepValue<bool>? _isLatestRevision;

    /// <summary>
    /// Associates a traffic label with a revision.
    /// </summary>
    public BicepValue<string> Label 
    {
        get { Initialize(); return _label!; }
        set { Initialize(); _label!.Assign(value); }
    }
    private BicepValue<string>? _label;

    /// <summary>
    /// Creates a new ContainerAppRevisionTrafficWeight.
    /// </summary>
    public ContainerAppRevisionTrafficWeight()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppRevisionTrafficWeight.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _revisionName = DefineProperty<string>("RevisionName", ["revisionName"]);
        _weight = DefineProperty<int>("Weight", ["weight"]);
        _isLatestRevision = DefineProperty<bool>("IsLatestRevision", ["latestRevision"]);
        _label = DefineProperty<string>("Label", ["label"]);
    }
}
