// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Container App registry information.
/// </summary>
public partial class ContainerAppRegistryInfo : ProvisionableConstruct
{
    /// <summary>
    /// registry server Url.
    /// </summary>
    public BicepValue<string> RegistryServer 
    {
        get { Initialize(); return _registryServer!; }
        set { Initialize(); _registryServer!.Assign(value); }
    }
    private BicepValue<string>? _registryServer;

    /// <summary>
    /// registry username.
    /// </summary>
    public BicepValue<string> RegistryUserName 
    {
        get { Initialize(); return _registryUserName!; }
        set { Initialize(); _registryUserName!.Assign(value); }
    }
    private BicepValue<string>? _registryUserName;

    /// <summary>
    /// registry secret.
    /// </summary>
    public BicepValue<string> RegistryPassword 
    {
        get { Initialize(); return _registryPassword!; }
        set { Initialize(); _registryPassword!.Assign(value); }
    }
    private BicepValue<string>? _registryPassword;

    /// <summary>
    /// Creates a new ContainerAppRegistryInfo.
    /// </summary>
    public ContainerAppRegistryInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppRegistryInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _registryServer = DefineProperty<string>("RegistryServer", ["registryUrl"]);
        _registryUserName = DefineProperty<string>("RegistryUserName", ["registryUserName"]);
        _registryPassword = DefineProperty<string>("RegistryPassword", ["registryPassword"]);
    }
}
