// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Container App Private Registry.
/// </summary>
public partial class ContainerAppRegistryCredentials : ProvisionableConstruct
{
    /// <summary>
    /// Container Registry Server.
    /// </summary>
    public BicepValue<string> Server 
    {
        get { Initialize(); return _server!; }
        set { Initialize(); _server!.Assign(value); }
    }
    private BicepValue<string>? _server;

    /// <summary>
    /// Container Registry Username.
    /// </summary>
    public BicepValue<string> Username 
    {
        get { Initialize(); return _username!; }
        set { Initialize(); _username!.Assign(value); }
    }
    private BicepValue<string>? _username;

    /// <summary>
    /// The name of the Secret that contains the registry login password.
    /// </summary>
    public BicepValue<string> PasswordSecretRef 
    {
        get { Initialize(); return _passwordSecretRef!; }
        set { Initialize(); _passwordSecretRef!.Assign(value); }
    }
    private BicepValue<string>? _passwordSecretRef;

    /// <summary>
    /// A Managed Identity to use to authenticate with Azure Container
    /// Registry. For user-assigned identities, use the full user-assigned
    /// identity Resource ID. For system-assigned identities, use
    /// &apos;system&apos;.
    /// </summary>
    public BicepValue<string> Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); _identity!.Assign(value); }
    }
    private BicepValue<string>? _identity;

    /// <summary>
    /// Creates a new ContainerAppRegistryCredentials.
    /// </summary>
    public ContainerAppRegistryCredentials()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppRegistryCredentials.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _server = DefineProperty<string>("Server", ["server"]);
        _username = DefineProperty<string>("Username", ["username"]);
        _passwordSecretRef = DefineProperty<string>("PasswordSecretRef", ["passwordSecretRef"]);
        _identity = DefineProperty<string>("Identity", ["identity"]);
    }
}
