// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Probe describes a health check to be performed against a container to
/// determine whether it is alive or ready to receive traffic.
/// </summary>
public partial class ContainerAppProbe : ProvisionableConstruct
{
    /// <summary>
    /// Minimum consecutive failures for the probe to be considered failed
    /// after having succeeded. Defaults to 3. Minimum value is 1. Maximum
    /// value is 10.
    /// </summary>
    public BicepValue<int> FailureThreshold 
    {
        get { Initialize(); return _failureThreshold!; }
        set { Initialize(); _failureThreshold!.Assign(value); }
    }
    private BicepValue<int>? _failureThreshold;

    /// <summary>
    /// HTTPGet specifies the http request to perform.
    /// </summary>
    public ContainerAppHttpRequestInfo HttpGet 
    {
        get { Initialize(); return _httpGet!; }
        set { Initialize(); AssignOrReplace(ref _httpGet, value); }
    }
    private ContainerAppHttpRequestInfo? _httpGet;

    /// <summary>
    /// Number of seconds after the container has started before liveness
    /// probes are initiated. Minimum value is 1. Maximum value is 60.
    /// </summary>
    public BicepValue<int> InitialDelaySeconds 
    {
        get { Initialize(); return _initialDelaySeconds!; }
        set { Initialize(); _initialDelaySeconds!.Assign(value); }
    }
    private BicepValue<int>? _initialDelaySeconds;

    /// <summary>
    /// How often (in seconds) to perform the probe. Default to 10 seconds.
    /// Minimum value is 1. Maximum value is 240.
    /// </summary>
    public BicepValue<int> PeriodSeconds 
    {
        get { Initialize(); return _periodSeconds!; }
        set { Initialize(); _periodSeconds!.Assign(value); }
    }
    private BicepValue<int>? _periodSeconds;

    /// <summary>
    /// Minimum consecutive successes for the probe to be considered successful
    /// after having failed. Defaults to 1. Must be 1 for liveness and
    /// startup. Minimum value is 1. Maximum value is 10.
    /// </summary>
    public BicepValue<int> SuccessThreshold 
    {
        get { Initialize(); return _successThreshold!; }
        set { Initialize(); _successThreshold!.Assign(value); }
    }
    private BicepValue<int>? _successThreshold;

    /// <summary>
    /// TCPSocket specifies an action involving a TCP port. TCP hooks not yet
    /// supported.
    /// </summary>
    public ContainerAppTcpSocketRequestInfo TcpSocket 
    {
        get { Initialize(); return _tcpSocket!; }
        set { Initialize(); AssignOrReplace(ref _tcpSocket, value); }
    }
    private ContainerAppTcpSocketRequestInfo? _tcpSocket;

    /// <summary>
    /// Optional duration in seconds the pod needs to terminate gracefully upon
    /// probe failure. The grace period is the duration in seconds after the
    /// processes running in the pod are sent a termination signal and the
    /// time when the processes are forcibly halted with a kill signal. Set
    /// this value longer than the expected cleanup time for your process. If
    /// this value is nil, the pod&apos;s terminationGracePeriodSeconds will
    /// be used. Otherwise, this value overrides the value provided by the pod
    /// spec. Value must be non-negative integer. The value zero indicates
    /// stop immediately via the kill signal (no opportunity to shut down).
    /// This is an alpha field and requires enabling
    /// ProbeTerminationGracePeriod feature gate. Maximum value is 3600
    /// seconds (1 hour).
    /// </summary>
    public BicepValue<long> TerminationGracePeriodSeconds 
    {
        get { Initialize(); return _terminationGracePeriodSeconds!; }
        set { Initialize(); _terminationGracePeriodSeconds!.Assign(value); }
    }
    private BicepValue<long>? _terminationGracePeriodSeconds;

    /// <summary>
    /// Number of seconds after which the probe times out. Defaults to 1
    /// second. Minimum value is 1. Maximum value is 240.
    /// </summary>
    public BicepValue<int> TimeoutSeconds 
    {
        get { Initialize(); return _timeoutSeconds!; }
        set { Initialize(); _timeoutSeconds!.Assign(value); }
    }
    private BicepValue<int>? _timeoutSeconds;

    /// <summary>
    /// The type of probe.
    /// </summary>
    public BicepValue<ContainerAppProbeType> ProbeType 
    {
        get { Initialize(); return _probeType!; }
        set { Initialize(); _probeType!.Assign(value); }
    }
    private BicepValue<ContainerAppProbeType>? _probeType;

    /// <summary>
    /// Creates a new ContainerAppProbe.
    /// </summary>
    public ContainerAppProbe()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppProbe.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _failureThreshold = DefineProperty<int>("FailureThreshold", ["failureThreshold"]);
        _httpGet = DefineModelProperty<ContainerAppHttpRequestInfo>("HttpGet", ["httpGet"]);
        _initialDelaySeconds = DefineProperty<int>("InitialDelaySeconds", ["initialDelaySeconds"]);
        _periodSeconds = DefineProperty<int>("PeriodSeconds", ["periodSeconds"]);
        _successThreshold = DefineProperty<int>("SuccessThreshold", ["successThreshold"]);
        _tcpSocket = DefineModelProperty<ContainerAppTcpSocketRequestInfo>("TcpSocket", ["tcpSocket"]);
        _terminationGracePeriodSeconds = DefineProperty<long>("TerminationGracePeriodSeconds", ["terminationGracePeriodSeconds"]);
        _timeoutSeconds = DefineProperty<int>("TimeoutSeconds", ["timeoutSeconds"]);
        _probeType = DefineProperty<ContainerAppProbeType>("ProbeType", ["type"]);
    }
}
