// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the app registration for the custom Open ID
/// Connect provider.
/// </summary>
public partial class ContainerAppOpenIdConnectRegistration : ProvisionableConstruct
{
    /// <summary>
    /// The client id of the custom Open ID Connect provider.
    /// </summary>
    public BicepValue<string> ClientId 
    {
        get { Initialize(); return _clientId!; }
        set { Initialize(); _clientId!.Assign(value); }
    }
    private BicepValue<string>? _clientId;

    /// <summary>
    /// The authentication credentials of the custom Open ID Connect provider.
    /// </summary>
    public ContainerAppOpenIdConnectClientCredential ClientCredential 
    {
        get { Initialize(); return _clientCredential!; }
        set { Initialize(); AssignOrReplace(ref _clientCredential, value); }
    }
    private ContainerAppOpenIdConnectClientCredential? _clientCredential;

    /// <summary>
    /// The configuration settings of the endpoints used for the custom Open ID
    /// Connect provider.
    /// </summary>
    public ContainerAppOpenIdConnectConfig OpenIdConnectConfiguration 
    {
        get { Initialize(); return _openIdConnectConfiguration!; }
        set { Initialize(); AssignOrReplace(ref _openIdConnectConfiguration, value); }
    }
    private ContainerAppOpenIdConnectConfig? _openIdConnectConfiguration;

    /// <summary>
    /// Creates a new ContainerAppOpenIdConnectRegistration.
    /// </summary>
    public ContainerAppOpenIdConnectRegistration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppOpenIdConnectRegistration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _clientId = DefineProperty<string>("ClientId", ["clientId"]);
        _clientCredential = DefineModelProperty<ContainerAppOpenIdConnectClientCredential>("ClientCredential", ["clientCredential"]);
        _openIdConnectConfiguration = DefineModelProperty<ContainerAppOpenIdConnectConfig>("OpenIdConnectConfiguration", ["openIdConnectConfiguration"]);
    }
}
