// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the login flow of the custom Open ID Connect
/// provider.
/// </summary>
public partial class ContainerAppOpenIdConnectLogin : ProvisionableConstruct
{
    /// <summary>
    /// The name of the claim that contains the users name.
    /// </summary>
    public BicepValue<string> NameClaimType 
    {
        get { Initialize(); return _nameClaimType!; }
        set { Initialize(); _nameClaimType!.Assign(value); }
    }
    private BicepValue<string>? _nameClaimType;

    /// <summary>
    /// A list of the scopes that should be requested while authenticating.
    /// </summary>
    public BicepList<string> Scopes 
    {
        get { Initialize(); return _scopes!; }
        set { Initialize(); _scopes!.Assign(value); }
    }
    private BicepList<string>? _scopes;

    /// <summary>
    /// Creates a new ContainerAppOpenIdConnectLogin.
    /// </summary>
    public ContainerAppOpenIdConnectLogin()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppOpenIdConnectLogin.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _nameClaimType = DefineProperty<string>("NameClaimType", ["nameClaimType"]);
        _scopes = DefineListProperty<string>("Scopes", ["scopes"]);
    }
}
