// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the endpoints used for the custom Open ID
/// Connect provider.
/// </summary>
public partial class ContainerAppOpenIdConnectConfig : ProvisionableConstruct
{
    /// <summary>
    /// The endpoint to be used to make an authorization request.
    /// </summary>
    public BicepValue<string> AuthorizationEndpoint 
    {
        get { Initialize(); return _authorizationEndpoint!; }
        set { Initialize(); _authorizationEndpoint!.Assign(value); }
    }
    private BicepValue<string>? _authorizationEndpoint;

    /// <summary>
    /// The endpoint to be used to request a token.
    /// </summary>
    public BicepValue<string> TokenEndpoint 
    {
        get { Initialize(); return _tokenEndpoint!; }
        set { Initialize(); _tokenEndpoint!.Assign(value); }
    }
    private BicepValue<string>? _tokenEndpoint;

    /// <summary>
    /// The endpoint that issues the token.
    /// </summary>
    public BicepValue<string> Issuer 
    {
        get { Initialize(); return _issuer!; }
        set { Initialize(); _issuer!.Assign(value); }
    }
    private BicepValue<string>? _issuer;

    /// <summary>
    /// The endpoint that provides the keys necessary to validate the token.
    /// </summary>
    public BicepValue<Uri> CertificationUri 
    {
        get { Initialize(); return _certificationUri!; }
        set { Initialize(); _certificationUri!.Assign(value); }
    }
    private BicepValue<Uri>? _certificationUri;

    /// <summary>
    /// The endpoint that contains all the configuration endpoints for the
    /// provider.
    /// </summary>
    public BicepValue<string> WellKnownOpenIdConfiguration 
    {
        get { Initialize(); return _wellKnownOpenIdConfiguration!; }
        set { Initialize(); _wellKnownOpenIdConfiguration!.Assign(value); }
    }
    private BicepValue<string>? _wellKnownOpenIdConfiguration;

    /// <summary>
    /// Creates a new ContainerAppOpenIdConnectConfig.
    /// </summary>
    public ContainerAppOpenIdConnectConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppOpenIdConnectConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _authorizationEndpoint = DefineProperty<string>("AuthorizationEndpoint", ["authorizationEndpoint"]);
        _tokenEndpoint = DefineProperty<string>("TokenEndpoint", ["tokenEndpoint"]);
        _issuer = DefineProperty<string>("Issuer", ["issuer"]);
        _certificationUri = DefineProperty<Uri>("CertificationUri", ["certificationUri"]);
        _wellKnownOpenIdConfiguration = DefineProperty<string>("WellKnownOpenIdConfiguration", ["wellKnownOpenIdConfiguration"]);
    }
}
