// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The authentication client credentials of the custom Open ID Connect
/// provider.
/// </summary>
public partial class ContainerAppOpenIdConnectClientCredential : ProvisionableConstruct
{
    /// <summary>
    /// The method that should be used to authenticate the user.
    /// </summary>
    public BicepValue<ContainerAppOpenIdConnectClientCredentialMethod> Method 
    {
        get { Initialize(); return _method!; }
        set { Initialize(); _method!.Assign(value); }
    }
    private BicepValue<ContainerAppOpenIdConnectClientCredentialMethod>? _method;

    /// <summary>
    /// The app setting that contains the client secret for the custom Open ID
    /// Connect provider.
    /// </summary>
    public BicepValue<string> ClientSecretSettingName 
    {
        get { Initialize(); return _clientSecretSettingName!; }
        set { Initialize(); _clientSecretSettingName!.Assign(value); }
    }
    private BicepValue<string>? _clientSecretSettingName;

    /// <summary>
    /// Creates a new ContainerAppOpenIdConnectClientCredential.
    /// </summary>
    public ContainerAppOpenIdConnectClientCredential()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppOpenIdConnectClientCredential.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _method = DefineProperty<ContainerAppOpenIdConnectClientCredentialMethod>("Method", ["method"]);
        _clientSecretSettingName = DefineProperty<string>("ClientSecretSettingName", ["clientSecretSettingName"]);
    }
}
