// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the nonce used in the login flow.
/// </summary>
public partial class ContainerAppLoginNonce : ProvisionableConstruct
{
    /// <summary>
    /// &lt;code&gt;false&lt;/code&gt; if the nonce should not be validated
    /// while completing the login flow; otherwise,
    /// &lt;code&gt;true&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> ValidateNonce 
    {
        get { Initialize(); return _validateNonce!; }
        set { Initialize(); _validateNonce!.Assign(value); }
    }
    private BicepValue<bool>? _validateNonce;

    /// <summary>
    /// The time after the request is made when the nonce should expire.
    /// </summary>
    public BicepValue<string> NonceExpirationInterval 
    {
        get { Initialize(); return _nonceExpirationInterval!; }
        set { Initialize(); _nonceExpirationInterval!.Assign(value); }
    }
    private BicepValue<string>? _nonceExpirationInterval;

    /// <summary>
    /// Creates a new ContainerAppLoginNonce.
    /// </summary>
    public ContainerAppLoginNonce()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppLoginNonce.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _validateNonce = DefineProperty<bool>("ValidateNonce", ["validateNonce"]);
        _nonceExpirationInterval = DefineProperty<string>("NonceExpirationInterval", ["nonceExpirationInterval"]);
    }
}
