// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the login flow of users using ContainerApp
/// Service Authentication/Authorization.
/// </summary>
public partial class ContainerAppLogin : ProvisionableConstruct
{
    /// <summary>
    /// The endpoint at which a logout request should be made.
    /// </summary>
    public BicepValue<string> RoutesLogoutEndpoint 
    {
        get { Initialize(); return _routesLogoutEndpoint!; }
        set { Initialize(); _routesLogoutEndpoint!.Assign(value); }
    }
    private BicepValue<string>? _routesLogoutEndpoint;

    /// <summary>
    /// The configuration settings of the token store.
    /// </summary>
    public ContainerAppTokenStore TokenStore 
    {
        get { Initialize(); return _tokenStore!; }
        set { Initialize(); AssignOrReplace(ref _tokenStore, value); }
    }
    private ContainerAppTokenStore? _tokenStore;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if the fragments from the request are
    /// preserved after the login request is made; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> PreserveUrlFragmentsForLogins 
    {
        get { Initialize(); return _preserveUrlFragmentsForLogins!; }
        set { Initialize(); _preserveUrlFragmentsForLogins!.Assign(value); }
    }
    private BicepValue<bool>? _preserveUrlFragmentsForLogins;

    /// <summary>
    /// External URLs that can be redirected to as part of logging in or
    /// logging out of the app. Note that the query string part of the URL is
    /// ignored.             This is an advanced setting typically only needed
    /// by Windows Store application backends.             Note that URLs
    /// within the current domain are always implicitly allowed.
    /// </summary>
    public BicepList<string> AllowedExternalRedirectUrls 
    {
        get { Initialize(); return _allowedExternalRedirectUrls!; }
        set { Initialize(); _allowedExternalRedirectUrls!.Assign(value); }
    }
    private BicepList<string>? _allowedExternalRedirectUrls;

    /// <summary>
    /// The configuration settings of the session cookie&apos;s expiration.
    /// </summary>
    public ContainerAppCookieExpiration CookieExpiration 
    {
        get { Initialize(); return _cookieExpiration!; }
        set { Initialize(); AssignOrReplace(ref _cookieExpiration, value); }
    }
    private ContainerAppCookieExpiration? _cookieExpiration;

    /// <summary>
    /// The configuration settings of the nonce used in the login flow.
    /// </summary>
    public ContainerAppLoginNonce Nonce 
    {
        get { Initialize(); return _nonce!; }
        set { Initialize(); AssignOrReplace(ref _nonce, value); }
    }
    private ContainerAppLoginNonce? _nonce;

    /// <summary>
    /// Creates a new ContainerAppLogin.
    /// </summary>
    public ContainerAppLogin()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppLogin.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _routesLogoutEndpoint = DefineProperty<string>("RoutesLogoutEndpoint", ["routes", "logoutEndpoint"]);
        _tokenStore = DefineModelProperty<ContainerAppTokenStore>("TokenStore", ["tokenStore"]);
        _preserveUrlFragmentsForLogins = DefineProperty<bool>("PreserveUrlFragmentsForLogins", ["preserveUrlFragmentsForLogins"]);
        _allowedExternalRedirectUrls = DefineListProperty<string>("AllowedExternalRedirectUrls", ["allowedExternalRedirectUrls"]);
        _cookieExpiration = DefineModelProperty<ContainerAppCookieExpiration>("CookieExpiration", ["cookieExpiration"]);
        _nonce = DefineModelProperty<ContainerAppLoginNonce>("Nonce", ["nonce"]);
    }
}
