// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Log Analytics configuration, must only be provided when destination is
/// configured as &apos;log-analytics&apos;.
/// </summary>
public partial class ContainerAppLogAnalyticsConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Log analytics customer id.
    /// </summary>
    public BicepValue<string> CustomerId 
    {
        get { Initialize(); return _customerId!; }
        set { Initialize(); _customerId!.Assign(value); }
    }
    private BicepValue<string>? _customerId;

    /// <summary>
    /// Log analytics customer key.
    /// </summary>
    public BicepValue<string> SharedKey 
    {
        get { Initialize(); return _sharedKey!; }
        set { Initialize(); _sharedKey!.Assign(value); }
    }
    private BicepValue<string>? _sharedKey;

    /// <summary>
    /// Creates a new ContainerAppLogAnalyticsConfiguration.
    /// </summary>
    public ContainerAppLogAnalyticsConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppLogAnalyticsConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _customerId = DefineProperty<string>("CustomerId", ["customerId"]);
        _sharedKey = DefineProperty<string>("SharedKey", ["sharedKey"]);
    }
}
