// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the checks that should be made while
/// validating the JWT Claims.
/// </summary>
public partial class ContainerAppJwtClaimChecks : ProvisionableConstruct
{
    /// <summary>
    /// The list of the allowed groups.
    /// </summary>
    public BicepList<string> AllowedGroups 
    {
        get { Initialize(); return _allowedGroups!; }
        set { Initialize(); _allowedGroups!.Assign(value); }
    }
    private BicepList<string>? _allowedGroups;

    /// <summary>
    /// The list of the allowed client applications.
    /// </summary>
    public BicepList<string> AllowedClientApplications 
    {
        get { Initialize(); return _allowedClientApplications!; }
        set { Initialize(); _allowedClientApplications!.Assign(value); }
    }
    private BicepList<string>? _allowedClientApplications;

    /// <summary>
    /// Creates a new ContainerAppJwtClaimChecks.
    /// </summary>
    public ContainerAppJwtClaimChecks()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppJwtClaimChecks.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _allowedGroups = DefineListProperty<string>("AllowedGroups", ["allowedGroups"]);
        _allowedClientApplications = DefineListProperty<string>("AllowedClientApplications", ["allowedClientApplications"]);
    }
}
