// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Container Apps Job versioned application definition. Defines the desired
/// state of an immutable revision. Any changes to this section Will result in
/// a new revision being created.
/// </summary>
public partial class ContainerAppJobTemplate : ProvisionableConstruct
{
    /// <summary>
    /// List of specialized containers that run before app containers.
    /// </summary>
    public BicepList<ContainerAppInitContainer> InitContainers 
    {
        get { Initialize(); return _initContainers!; }
        set { Initialize(); _initContainers!.Assign(value); }
    }
    private BicepList<ContainerAppInitContainer>? _initContainers;

    /// <summary>
    /// List of container definitions for the Container App.
    /// </summary>
    public BicepList<ContainerAppContainer> Containers 
    {
        get { Initialize(); return _containers!; }
        set { Initialize(); _containers!.Assign(value); }
    }
    private BicepList<ContainerAppContainer>? _containers;

    /// <summary>
    /// List of volume definitions for the Container App.
    /// </summary>
    public BicepList<ContainerAppVolume> Volumes 
    {
        get { Initialize(); return _volumes!; }
        set { Initialize(); _volumes!.Assign(value); }
    }
    private BicepList<ContainerAppVolume>? _volumes;

    /// <summary>
    /// Creates a new ContainerAppJobTemplate.
    /// </summary>
    public ContainerAppJobTemplate()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppJobTemplate.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _initContainers = DefineListProperty<ContainerAppInitContainer>("InitContainers", ["initContainers"]);
        _containers = DefineListProperty<ContainerAppContainer>("Containers", ["containers"]);
        _volumes = DefineListProperty<ContainerAppVolume>("Volumes", ["volumes"]);
    }
}
