// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Scaling rule.
/// </summary>
public partial class ContainerAppJobScaleRule : ProvisionableConstruct
{
    /// <summary>
    /// Scale Rule Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Type of the scale rule             eg: azure-servicebus, redis etc.
    /// </summary>
    public BicepValue<string> JobScaleRuleType 
    {
        get { Initialize(); return _jobScaleRuleType!; }
        set { Initialize(); _jobScaleRuleType!.Assign(value); }
    }
    private BicepValue<string>? _jobScaleRuleType;

    /// <summary>
    /// Metadata properties to describe the scale rule.
    /// To assign an object to this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepValue<BinaryData> Metadata 
    {
        get { Initialize(); return _metadata!; }
        set { Initialize(); _metadata!.Assign(value); }
    }
    private BicepValue<BinaryData>? _metadata;

    /// <summary>
    /// Authentication secrets for the scale rule.
    /// </summary>
    public BicepList<ContainerAppScaleRuleAuth> Auth 
    {
        get { Initialize(); return _auth!; }
        set { Initialize(); _auth!.Assign(value); }
    }
    private BicepList<ContainerAppScaleRuleAuth>? _auth;

    /// <summary>
    /// Creates a new ContainerAppJobScaleRule.
    /// </summary>
    public ContainerAppJobScaleRule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppJobScaleRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _jobScaleRuleType = DefineProperty<string>("JobScaleRuleType", ["type"]);
        _metadata = DefineProperty<BinaryData>("Metadata", ["metadata"]);
        _auth = DefineListProperty<ContainerAppScaleRuleAuth>("Auth", ["auth"]);
    }
}
