// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Scaling configurations for event driven jobs.
/// </summary>
public partial class ContainerAppJobScale : ProvisionableConstruct
{
    /// <summary>
    /// Interval to check each event source in seconds. Defaults to 30s.
    /// </summary>
    public BicepValue<int> PollingIntervalInSeconds 
    {
        get { Initialize(); return _pollingIntervalInSeconds!; }
        set { Initialize(); _pollingIntervalInSeconds!.Assign(value); }
    }
    private BicepValue<int>? _pollingIntervalInSeconds;

    /// <summary>
    /// Minimum number of job executions that are created for a trigger,
    /// default 0.
    /// </summary>
    public BicepValue<int> MinExecutions 
    {
        get { Initialize(); return _minExecutions!; }
        set { Initialize(); _minExecutions!.Assign(value); }
    }
    private BicepValue<int>? _minExecutions;

    /// <summary>
    /// Maximum number of job executions that are created for a trigger,
    /// default 100.
    /// </summary>
    public BicepValue<int> MaxExecutions 
    {
        get { Initialize(); return _maxExecutions!; }
        set { Initialize(); _maxExecutions!.Assign(value); }
    }
    private BicepValue<int>? _maxExecutions;

    /// <summary>
    /// Scaling rules.
    /// </summary>
    public BicepList<ContainerAppJobScaleRule> Rules 
    {
        get { Initialize(); return _rules!; }
        set { Initialize(); _rules!.Assign(value); }
    }
    private BicepList<ContainerAppJobScaleRule>? _rules;

    /// <summary>
    /// Creates a new ContainerAppJobScale.
    /// </summary>
    public ContainerAppJobScale()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppJobScale.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _pollingIntervalInSeconds = DefineProperty<int>("PollingIntervalInSeconds", ["pollingInterval"]);
        _minExecutions = DefineProperty<int>("MinExecutions", ["minExecutions"]);
        _maxExecutions = DefineProperty<int>("MaxExecutions", ["maxExecutions"]);
        _rules = DefineListProperty<ContainerAppJobScaleRule>("Rules", ["rules"]);
    }
}
