// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Non versioned Container Apps Job configuration properties.
/// </summary>
public partial class ContainerAppJobConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Collection of secrets used by a Container Apps Job.
    /// </summary>
    public BicepList<ContainerAppWritableSecret> Secrets 
    {
        get { Initialize(); return _secrets!; }
        set { Initialize(); _secrets!.Assign(value); }
    }
    private BicepList<ContainerAppWritableSecret>? _secrets;

    /// <summary>
    /// Trigger type of the job.
    /// </summary>
    public BicepValue<ContainerAppJobTriggerType> TriggerType 
    {
        get { Initialize(); return _triggerType!; }
        set { Initialize(); _triggerType!.Assign(value); }
    }
    private BicepValue<ContainerAppJobTriggerType>? _triggerType;

    /// <summary>
    /// Maximum number of seconds a replica is allowed to run.
    /// </summary>
    public BicepValue<int> ReplicaTimeout 
    {
        get { Initialize(); return _replicaTimeout!; }
        set { Initialize(); _replicaTimeout!.Assign(value); }
    }
    private BicepValue<int>? _replicaTimeout;

    /// <summary>
    /// Maximum number of retries before failing the job.
    /// </summary>
    public BicepValue<int> ReplicaRetryLimit 
    {
        get { Initialize(); return _replicaRetryLimit!; }
        set { Initialize(); _replicaRetryLimit!.Assign(value); }
    }
    private BicepValue<int>? _replicaRetryLimit;

    /// <summary>
    /// Manual trigger configuration for a single execution job. Properties
    /// replicaCompletionCount and parallelism would be set to 1 by default.
    /// </summary>
    public JobConfigurationManualTriggerConfig ManualTriggerConfig 
    {
        get { Initialize(); return _manualTriggerConfig!; }
        set { Initialize(); AssignOrReplace(ref _manualTriggerConfig, value); }
    }
    private JobConfigurationManualTriggerConfig? _manualTriggerConfig;

    /// <summary>
    /// Cron formatted repeating trigger schedule (&quot;* * * * *&quot;) for
    /// cronjobs. Properties completions and parallelism would be set to 1 by
    /// default.
    /// </summary>
    public JobConfigurationScheduleTriggerConfig ScheduleTriggerConfig 
    {
        get { Initialize(); return _scheduleTriggerConfig!; }
        set { Initialize(); AssignOrReplace(ref _scheduleTriggerConfig, value); }
    }
    private JobConfigurationScheduleTriggerConfig? _scheduleTriggerConfig;

    /// <summary>
    /// Trigger configuration of an event driven job.
    /// </summary>
    public EventTriggerConfiguration EventTriggerConfig 
    {
        get { Initialize(); return _eventTriggerConfig!; }
        set { Initialize(); AssignOrReplace(ref _eventTriggerConfig, value); }
    }
    private EventTriggerConfiguration? _eventTriggerConfig;

    /// <summary>
    /// Collection of private container registry credentials used by a
    /// Container apps job.
    /// </summary>
    public BicepList<ContainerAppRegistryCredentials> Registries 
    {
        get { Initialize(); return _registries!; }
        set { Initialize(); _registries!.Assign(value); }
    }
    private BicepList<ContainerAppRegistryCredentials>? _registries;

    /// <summary>
    /// Creates a new ContainerAppJobConfiguration.
    /// </summary>
    public ContainerAppJobConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppJobConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _secrets = DefineListProperty<ContainerAppWritableSecret>("Secrets", ["secrets"]);
        _triggerType = DefineProperty<ContainerAppJobTriggerType>("TriggerType", ["triggerType"]);
        _replicaTimeout = DefineProperty<int>("ReplicaTimeout", ["replicaTimeout"]);
        _replicaRetryLimit = DefineProperty<int>("ReplicaRetryLimit", ["replicaRetryLimit"]);
        _manualTriggerConfig = DefineModelProperty<JobConfigurationManualTriggerConfig>("ManualTriggerConfig", ["manualTriggerConfig"]);
        _scheduleTriggerConfig = DefineModelProperty<JobConfigurationScheduleTriggerConfig>("ScheduleTriggerConfig", ["scheduleTriggerConfig"]);
        _eventTriggerConfig = DefineModelProperty<EventTriggerConfiguration>("EventTriggerConfig", ["eventTriggerConfig"]);
        _registries = DefineListProperty<ContainerAppRegistryCredentials>("Registries", ["registries"]);
    }
}
