// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Container App init container definition.
/// </summary>
public partial class ContainerAppInitContainer : ProvisionableConstruct
{
    /// <summary>
    /// Container image tag.
    /// </summary>
    public BicepValue<string> Image 
    {
        get { Initialize(); return _image!; }
        set { Initialize(); _image!.Assign(value); }
    }
    private BicepValue<string>? _image;

    /// <summary>
    /// Custom container name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Container start command.
    /// </summary>
    public BicepList<string> Command 
    {
        get { Initialize(); return _command!; }
        set { Initialize(); _command!.Assign(value); }
    }
    private BicepList<string>? _command;

    /// <summary>
    /// Container start command arguments.
    /// </summary>
    public BicepList<string> Args 
    {
        get { Initialize(); return _args!; }
        set { Initialize(); _args!.Assign(value); }
    }
    private BicepList<string>? _args;

    /// <summary>
    /// Container environment variables.
    /// </summary>
    public BicepList<ContainerAppEnvironmentVariable> Env 
    {
        get { Initialize(); return _env!; }
        set { Initialize(); _env!.Assign(value); }
    }
    private BicepList<ContainerAppEnvironmentVariable>? _env;

    /// <summary>
    /// Container resource requirements.
    /// </summary>
    public AppContainerResources Resources 
    {
        get { Initialize(); return _resources!; }
        set { Initialize(); AssignOrReplace(ref _resources, value); }
    }
    private AppContainerResources? _resources;

    /// <summary>
    /// Container volume mounts.
    /// </summary>
    public BicepList<ContainerAppVolumeMount> VolumeMounts 
    {
        get { Initialize(); return _volumeMounts!; }
        set { Initialize(); _volumeMounts!.Assign(value); }
    }
    private BicepList<ContainerAppVolumeMount>? _volumeMounts;

    /// <summary>
    /// Creates a new ContainerAppInitContainer.
    /// </summary>
    public ContainerAppInitContainer()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppInitContainer.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _image = DefineProperty<string>("Image", ["image"]);
        _name = DefineProperty<string>("Name", ["name"]);
        _command = DefineListProperty<string>("Command", ["command"]);
        _args = DefineListProperty<string>("Args", ["args"]);
        _env = DefineListProperty<ContainerAppEnvironmentVariable>("Env", ["env"]);
        _resources = DefineModelProperty<AppContainerResources>("Resources", ["resources"]);
        _volumeMounts = DefineListProperty<ContainerAppVolumeMount>("VolumeMounts", ["volumeMounts"]);
    }
}
