// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Container App Ingress configuration.
/// </summary>
public partial class ContainerAppIngressConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Hostname.
    /// </summary>
    public BicepValue<string> Fqdn 
    {
        get { Initialize(); return _fqdn!; }
    }
    private BicepValue<string>? _fqdn;

    /// <summary>
    /// Bool indicating if app exposes an external http endpoint.
    /// </summary>
    public BicepValue<bool> External 
    {
        get { Initialize(); return _external!; }
        set { Initialize(); _external!.Assign(value); }
    }
    private BicepValue<bool>? _external;

    /// <summary>
    /// Target Port in containers for traffic from ingress.
    /// </summary>
    public BicepValue<int> TargetPort 
    {
        get { Initialize(); return _targetPort!; }
        set { Initialize(); _targetPort!.Assign(value); }
    }
    private BicepValue<int>? _targetPort;

    /// <summary>
    /// Exposed Port in containers for TCP traffic from ingress.
    /// </summary>
    public BicepValue<int> ExposedPort 
    {
        get { Initialize(); return _exposedPort!; }
        set { Initialize(); _exposedPort!.Assign(value); }
    }
    private BicepValue<int>? _exposedPort;

    /// <summary>
    /// Ingress transport protocol.
    /// </summary>
    public BicepValue<ContainerAppIngressTransportMethod> Transport 
    {
        get { Initialize(); return _transport!; }
        set { Initialize(); _transport!.Assign(value); }
    }
    private BicepValue<ContainerAppIngressTransportMethod>? _transport;

    /// <summary>
    /// Traffic weights for app&apos;s revisions.
    /// </summary>
    public BicepList<ContainerAppRevisionTrafficWeight> Traffic 
    {
        get { Initialize(); return _traffic!; }
        set { Initialize(); _traffic!.Assign(value); }
    }
    private BicepList<ContainerAppRevisionTrafficWeight>? _traffic;

    /// <summary>
    /// custom domain bindings for Container Apps&apos; hostnames.
    /// </summary>
    public BicepList<ContainerAppCustomDomain> CustomDomains 
    {
        get { Initialize(); return _customDomains!; }
        set { Initialize(); _customDomains!.Assign(value); }
    }
    private BicepList<ContainerAppCustomDomain>? _customDomains;

    /// <summary>
    /// Bool indicating if HTTP connections to is allowed. If set to false HTTP
    /// connections are automatically redirected to HTTPS connections.
    /// </summary>
    public BicepValue<bool> AllowInsecure 
    {
        get { Initialize(); return _allowInsecure!; }
        set { Initialize(); _allowInsecure!.Assign(value); }
    }
    private BicepValue<bool>? _allowInsecure;

    /// <summary>
    /// Rules to restrict incoming IP address.
    /// </summary>
    public BicepList<ContainerAppIPSecurityRestrictionRule> IPSecurityRestrictions 
    {
        get { Initialize(); return _iPSecurityRestrictions!; }
        set { Initialize(); _iPSecurityRestrictions!.Assign(value); }
    }
    private BicepList<ContainerAppIPSecurityRestrictionRule>? _iPSecurityRestrictions;

    /// <summary>
    /// Sticky Session Affinity.
    /// </summary>
    public BicepValue<StickySessionAffinity> StickySessionsAffinity 
    {
        get { Initialize(); return _stickySessionsAffinity!; }
        set { Initialize(); _stickySessionsAffinity!.Assign(value); }
    }
    private BicepValue<StickySessionAffinity>? _stickySessionsAffinity;

    /// <summary>
    /// Client certificate mode for mTLS authentication. Ignore indicates
    /// server drops client certificate on forwarding. Accept indicates server
    /// forwards client certificate but does not require a client certificate.
    /// Require indicates server requires a client certificate.
    /// </summary>
    public BicepValue<ContainerAppIngressClientCertificateMode> ClientCertificateMode 
    {
        get { Initialize(); return _clientCertificateMode!; }
        set { Initialize(); _clientCertificateMode!.Assign(value); }
    }
    private BicepValue<ContainerAppIngressClientCertificateMode>? _clientCertificateMode;

    /// <summary>
    /// CORS policy for container app.
    /// </summary>
    public ContainerAppCorsPolicy CorsPolicy 
    {
        get { Initialize(); return _corsPolicy!; }
        set { Initialize(); AssignOrReplace(ref _corsPolicy, value); }
    }
    private ContainerAppCorsPolicy? _corsPolicy;

    /// <summary>
    /// Settings to expose additional ports on container app.
    /// </summary>
    public BicepList<IngressPortMapping> AdditionalPortMappings 
    {
        get { Initialize(); return _additionalPortMappings!; }
        set { Initialize(); _additionalPortMappings!.Assign(value); }
    }
    private BicepList<IngressPortMapping>? _additionalPortMappings;

    /// <summary>
    /// Creates a new ContainerAppIngressConfiguration.
    /// </summary>
    public ContainerAppIngressConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppIngressConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _fqdn = DefineProperty<string>("Fqdn", ["fqdn"], isOutput: true);
        _external = DefineProperty<bool>("External", ["external"]);
        _targetPort = DefineProperty<int>("TargetPort", ["targetPort"]);
        _exposedPort = DefineProperty<int>("ExposedPort", ["exposedPort"]);
        _transport = DefineProperty<ContainerAppIngressTransportMethod>("Transport", ["transport"]);
        _traffic = DefineListProperty<ContainerAppRevisionTrafficWeight>("Traffic", ["traffic"]);
        _customDomains = DefineListProperty<ContainerAppCustomDomain>("CustomDomains", ["customDomains"]);
        _allowInsecure = DefineProperty<bool>("AllowInsecure", ["allowInsecure"]);
        _iPSecurityRestrictions = DefineListProperty<ContainerAppIPSecurityRestrictionRule>("IPSecurityRestrictions", ["ipSecurityRestrictions"]);
        _stickySessionsAffinity = DefineProperty<StickySessionAffinity>("StickySessionsAffinity", ["stickySessions", "affinity"]);
        _clientCertificateMode = DefineProperty<ContainerAppIngressClientCertificateMode>("ClientCertificateMode", ["clientCertificateMode"]);
        _corsPolicy = DefineModelProperty<ContainerAppCorsPolicy>("CorsPolicy", ["corsPolicy"]);
        _additionalPortMappings = DefineListProperty<IngressPortMapping>("AdditionalPortMappings", ["additionalPortMappings"]);
    }
}
