// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of each of the identity providers used to
/// configure ContainerApp Service Authentication/Authorization.
/// </summary>
public partial class ContainerAppIdentityProvidersConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// The configuration settings of the Azure Active directory provider.
    /// </summary>
    public ContainerAppAzureActiveDirectoryConfiguration AzureActiveDirectory 
    {
        get { Initialize(); return _azureActiveDirectory!; }
        set { Initialize(); AssignOrReplace(ref _azureActiveDirectory, value); }
    }
    private ContainerAppAzureActiveDirectoryConfiguration? _azureActiveDirectory;

    /// <summary>
    /// The configuration settings of the Facebook provider.
    /// </summary>
    public ContainerAppFacebookConfiguration Facebook 
    {
        get { Initialize(); return _facebook!; }
        set { Initialize(); AssignOrReplace(ref _facebook, value); }
    }
    private ContainerAppFacebookConfiguration? _facebook;

    /// <summary>
    /// The configuration settings of the GitHub provider.
    /// </summary>
    public ContainerAppGitHubConfiguration GitHub 
    {
        get { Initialize(); return _gitHub!; }
        set { Initialize(); AssignOrReplace(ref _gitHub, value); }
    }
    private ContainerAppGitHubConfiguration? _gitHub;

    /// <summary>
    /// The configuration settings of the Google provider.
    /// </summary>
    public ContainerAppGoogleConfiguration Google 
    {
        get { Initialize(); return _google!; }
        set { Initialize(); AssignOrReplace(ref _google, value); }
    }
    private ContainerAppGoogleConfiguration? _google;

    /// <summary>
    /// The configuration settings of the Twitter provider.
    /// </summary>
    public ContainerAppTwitterConfiguration Twitter 
    {
        get { Initialize(); return _twitter!; }
        set { Initialize(); AssignOrReplace(ref _twitter, value); }
    }
    private ContainerAppTwitterConfiguration? _twitter;

    /// <summary>
    /// The configuration settings of the Apple provider.
    /// </summary>
    public ContainerAppAppleConfiguration Apple 
    {
        get { Initialize(); return _apple!; }
        set { Initialize(); AssignOrReplace(ref _apple, value); }
    }
    private ContainerAppAppleConfiguration? _apple;

    /// <summary>
    /// The configuration settings of the Azure Static Web Apps provider.
    /// </summary>
    public ContainerAppAzureStaticWebAppsConfiguration AzureStaticWebApps 
    {
        get { Initialize(); return _azureStaticWebApps!; }
        set { Initialize(); AssignOrReplace(ref _azureStaticWebApps, value); }
    }
    private ContainerAppAzureStaticWebAppsConfiguration? _azureStaticWebApps;

    /// <summary>
    /// The map of the name of the alias of each custom Open ID Connect
    /// provider to the             configuration settings of the custom Open
    /// ID Connect provider.
    /// </summary>
    public BicepDictionary<ContainerAppCustomOpenIdConnectProviderConfiguration> CustomOpenIdConnectProviders 
    {
        get { Initialize(); return _customOpenIdConnectProviders!; }
        set { Initialize(); _customOpenIdConnectProviders!.Assign(value); }
    }
    private BicepDictionary<ContainerAppCustomOpenIdConnectProviderConfiguration>? _customOpenIdConnectProviders;

    /// <summary>
    /// Creates a new ContainerAppIdentityProvidersConfiguration.
    /// </summary>
    public ContainerAppIdentityProvidersConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppIdentityProvidersConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _azureActiveDirectory = DefineModelProperty<ContainerAppAzureActiveDirectoryConfiguration>("AzureActiveDirectory", ["azureActiveDirectory"]);
        _facebook = DefineModelProperty<ContainerAppFacebookConfiguration>("Facebook", ["facebook"]);
        _gitHub = DefineModelProperty<ContainerAppGitHubConfiguration>("GitHub", ["gitHub"]);
        _google = DefineModelProperty<ContainerAppGoogleConfiguration>("Google", ["google"]);
        _twitter = DefineModelProperty<ContainerAppTwitterConfiguration>("Twitter", ["twitter"]);
        _apple = DefineModelProperty<ContainerAppAppleConfiguration>("Apple", ["apple"]);
        _azureStaticWebApps = DefineModelProperty<ContainerAppAzureStaticWebAppsConfiguration>("AzureStaticWebApps", ["azureStaticWebApps"]);
        _customOpenIdConnectProviders = DefineDictionaryProperty<ContainerAppCustomOpenIdConnectProviderConfiguration>("CustomOpenIdConnectProviders", ["customOpenIdConnectProviders"]);
    }
}
