// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the HTTP requests for authentication and
/// authorization requests made against ContainerApp Service
/// Authentication/Authorization.
/// </summary>
public partial class ContainerAppHttpSettings : ProvisionableConstruct
{
    /// <summary>
    /// &lt;code&gt;false&lt;/code&gt; if the authentication/authorization
    /// responses not having the HTTPS scheme are permissible; otherwise,
    /// &lt;code&gt;true&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> RequireHttps 
    {
        get { Initialize(); return _requireHttps!; }
        set { Initialize(); _requireHttps!.Assign(value); }
    }
    private BicepValue<bool>? _requireHttps;

    /// <summary>
    /// The prefix that should precede all the authentication/authorization
    /// paths.
    /// </summary>
    public BicepValue<string> RoutesApiPrefix 
    {
        get { Initialize(); return _routesApiPrefix!; }
        set { Initialize(); _routesApiPrefix!.Assign(value); }
    }
    private BicepValue<string>? _routesApiPrefix;

    /// <summary>
    /// The configuration settings of a forward proxy used to make the requests.
    /// </summary>
    public ContainerAppForwardProxy ForwardProxy 
    {
        get { Initialize(); return _forwardProxy!; }
        set { Initialize(); AssignOrReplace(ref _forwardProxy, value); }
    }
    private ContainerAppForwardProxy? _forwardProxy;

    /// <summary>
    /// Creates a new ContainerAppHttpSettings.
    /// </summary>
    public ContainerAppHttpSettings()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppHttpSettings.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _requireHttps = DefineProperty<bool>("RequireHttps", ["requireHttps"]);
        _routesApiPrefix = DefineProperty<string>("RoutesApiPrefix", ["routes", "apiPrefix"]);
        _forwardProxy = DefineModelProperty<ContainerAppForwardProxy>("ForwardProxy", ["forwardProxy"]);
    }
}
