// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// HTTPHeader describes a custom header to be used in HTTP probes.
/// </summary>
public partial class ContainerAppHttpHeaderInfo : ProvisionableConstruct
{
    /// <summary>
    /// The header field name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The header field value.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// Creates a new ContainerAppHttpHeaderInfo.
    /// </summary>
    public ContainerAppHttpHeaderInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppHttpHeaderInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _value = DefineProperty<string>("Value", ["value"]);
    }
}
