// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the Google provider.
/// </summary>
public partial class ContainerAppGoogleConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// &lt;code&gt;false&lt;/code&gt; if the Google provider should not be
    /// enabled despite the set registration; otherwise,
    /// &lt;code&gt;true&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// The configuration settings of the app registration for the Google
    /// provider.
    /// </summary>
    public ContainerAppClientRegistration Registration 
    {
        get { Initialize(); return _registration!; }
        set { Initialize(); AssignOrReplace(ref _registration, value); }
    }
    private ContainerAppClientRegistration? _registration;

    /// <summary>
    /// A list of the scopes that should be requested while authenticating.
    /// </summary>
    public BicepList<string> LoginScopes 
    {
        get { Initialize(); return _loginScopes!; }
        set { Initialize(); _loginScopes!.Assign(value); }
    }
    private BicepList<string>? _loginScopes;

    /// <summary>
    /// The configuration settings of the allowed list of audiences from which
    /// to validate the JWT token.
    /// </summary>
    public BicepList<string> ValidationAllowedAudiences 
    {
        get { Initialize(); return _validationAllowedAudiences!; }
        set { Initialize(); _validationAllowedAudiences!.Assign(value); }
    }
    private BicepList<string>? _validationAllowedAudiences;

    /// <summary>
    /// Creates a new ContainerAppGoogleConfiguration.
    /// </summary>
    public ContainerAppGoogleConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppGoogleConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _registration = DefineModelProperty<ContainerAppClientRegistration>("Registration", ["registration"]);
        _loginScopes = DefineListProperty<string>("LoginScopes", ["login", "scopes"]);
        _validationAllowedAudiences = DefineListProperty<string>("ValidationAllowedAudiences", ["validation", "allowedAudiences"]);
    }
}
