// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings that determines the validation flow of users
/// using ContainerApp Service Authentication/Authorization.
/// </summary>
public partial class ContainerAppGlobalValidation : ProvisionableConstruct
{
    /// <summary>
    /// The action to take when an unauthenticated client attempts to access
    /// the app.
    /// </summary>
    public BicepValue<ContainerAppUnauthenticatedClientActionV2> UnauthenticatedClientAction 
    {
        get { Initialize(); return _unauthenticatedClientAction!; }
        set { Initialize(); _unauthenticatedClientAction!.Assign(value); }
    }
    private BicepValue<ContainerAppUnauthenticatedClientActionV2>? _unauthenticatedClientAction;

    /// <summary>
    /// The default authentication provider to use when multiple providers are
    /// configured.             This setting is only needed if multiple
    /// providers are configured and the unauthenticated client
    /// action is set to &quot;RedirectToLoginPage&quot;.
    /// </summary>
    public BicepValue<string> RedirectToProvider 
    {
        get { Initialize(); return _redirectToProvider!; }
        set { Initialize(); _redirectToProvider!.Assign(value); }
    }
    private BicepValue<string>? _redirectToProvider;

    /// <summary>
    /// The paths for which unauthenticated flow would not be redirected to the
    /// login page.
    /// </summary>
    public BicepList<string> ExcludedPaths 
    {
        get { Initialize(); return _excludedPaths!; }
        set { Initialize(); _excludedPaths!.Assign(value); }
    }
    private BicepList<string>? _excludedPaths;

    /// <summary>
    /// Creates a new ContainerAppGlobalValidation.
    /// </summary>
    public ContainerAppGlobalValidation()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppGlobalValidation.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _unauthenticatedClientAction = DefineProperty<ContainerAppUnauthenticatedClientActionV2>("UnauthenticatedClientAction", ["unauthenticatedClientAction"]);
        _redirectToProvider = DefineProperty<string>("RedirectToProvider", ["redirectToProvider"]);
        _excludedPaths = DefineListProperty<string>("ExcludedPaths", ["excludedPaths"]);
    }
}
