// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Configuration properties that define the mutable settings of a Container
/// App SourceControl.
/// </summary>
public partial class ContainerAppGitHubActionConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Registry configurations.
    /// </summary>
    public ContainerAppRegistryInfo RegistryInfo 
    {
        get { Initialize(); return _registryInfo!; }
        set { Initialize(); AssignOrReplace(ref _registryInfo, value); }
    }
    private ContainerAppRegistryInfo? _registryInfo;

    /// <summary>
    /// AzureCredentials configurations.
    /// </summary>
    public ContainerAppCredentials AzureCredentials 
    {
        get { Initialize(); return _azureCredentials!; }
        set { Initialize(); AssignOrReplace(ref _azureCredentials, value); }
    }
    private ContainerAppCredentials? _azureCredentials;

    /// <summary>
    /// Context path.
    /// </summary>
    public BicepValue<string> ContextPath 
    {
        get { Initialize(); return _contextPath!; }
        set { Initialize(); _contextPath!.Assign(value); }
    }
    private BicepValue<string>? _contextPath;

    /// <summary>
    /// One time Github PAT to configure github environment.
    /// </summary>
    public BicepValue<string> GitHubPersonalAccessToken 
    {
        get { Initialize(); return _gitHubPersonalAccessToken!; }
        set { Initialize(); _gitHubPersonalAccessToken!.Assign(value); }
    }
    private BicepValue<string>? _gitHubPersonalAccessToken;

    /// <summary>
    /// Image name.
    /// </summary>
    public BicepValue<string> Image 
    {
        get { Initialize(); return _image!; }
        set { Initialize(); _image!.Assign(value); }
    }
    private BicepValue<string>? _image;

    /// <summary>
    /// Code or Image.
    /// </summary>
    public BicepValue<string> PublishType 
    {
        get { Initialize(); return _publishType!; }
        set { Initialize(); _publishType!.Assign(value); }
    }
    private BicepValue<string>? _publishType;

    /// <summary>
    /// Operation system.
    /// </summary>
    public BicepValue<string> OS 
    {
        get { Initialize(); return _oS!; }
        set { Initialize(); _oS!.Assign(value); }
    }
    private BicepValue<string>? _oS;

    /// <summary>
    /// Runtime stack.
    /// </summary>
    public BicepValue<string> RuntimeStack 
    {
        get { Initialize(); return _runtimeStack!; }
        set { Initialize(); _runtimeStack!.Assign(value); }
    }
    private BicepValue<string>? _runtimeStack;

    /// <summary>
    /// Runtime version.
    /// </summary>
    public BicepValue<string> RuntimeVersion 
    {
        get { Initialize(); return _runtimeVersion!; }
        set { Initialize(); _runtimeVersion!.Assign(value); }
    }
    private BicepValue<string>? _runtimeVersion;

    /// <summary>
    /// Creates a new ContainerAppGitHubActionConfiguration.
    /// </summary>
    public ContainerAppGitHubActionConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppGitHubActionConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _registryInfo = DefineModelProperty<ContainerAppRegistryInfo>("RegistryInfo", ["registryInfo"]);
        _azureCredentials = DefineModelProperty<ContainerAppCredentials>("AzureCredentials", ["azureCredentials"]);
        _contextPath = DefineProperty<string>("ContextPath", ["contextPath"]);
        _gitHubPersonalAccessToken = DefineProperty<string>("GitHubPersonalAccessToken", ["githubPersonalAccessToken"]);
        _image = DefineProperty<string>("Image", ["image"]);
        _publishType = DefineProperty<string>("PublishType", ["publishType"]);
        _oS = DefineProperty<string>("OS", ["os"]);
        _runtimeStack = DefineProperty<string>("RuntimeStack", ["runtimeStack"]);
        _runtimeVersion = DefineProperty<string>("RuntimeVersion", ["runtimeVersion"]);
    }
}
