// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of a forward proxy used to make the requests.
/// </summary>
public partial class ContainerAppForwardProxy : ProvisionableConstruct
{
    /// <summary>
    /// The convention used to determine the url of the request made.
    /// </summary>
    public BicepValue<ContainerAppForwardProxyConvention> Convention 
    {
        get { Initialize(); return _convention!; }
        set { Initialize(); _convention!.Assign(value); }
    }
    private BicepValue<ContainerAppForwardProxyConvention>? _convention;

    /// <summary>
    /// The name of the header containing the host of the request.
    /// </summary>
    public BicepValue<string> CustomHostHeaderName 
    {
        get { Initialize(); return _customHostHeaderName!; }
        set { Initialize(); _customHostHeaderName!.Assign(value); }
    }
    private BicepValue<string>? _customHostHeaderName;

    /// <summary>
    /// The name of the header containing the scheme of the request.
    /// </summary>
    public BicepValue<string> CustomProtoHeaderName 
    {
        get { Initialize(); return _customProtoHeaderName!; }
        set { Initialize(); _customProtoHeaderName!.Assign(value); }
    }
    private BicepValue<string>? _customProtoHeaderName;

    /// <summary>
    /// Creates a new ContainerAppForwardProxy.
    /// </summary>
    public ContainerAppForwardProxy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppForwardProxy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _convention = DefineProperty<ContainerAppForwardProxyConvention>("Convention", ["convention"]);
        _customHostHeaderName = DefineProperty<string>("CustomHostHeaderName", ["customHostHeaderName"]);
        _customProtoHeaderName = DefineProperty<string>("CustomProtoHeaderName", ["customProtoHeaderName"]);
    }
}
