// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the Facebook provider.
/// </summary>
public partial class ContainerAppFacebookConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// &lt;code&gt;false&lt;/code&gt; if the Facebook provider should not be
    /// enabled despite the set registration; otherwise,
    /// &lt;code&gt;true&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// The configuration settings of the app registration for the Facebook
    /// provider.
    /// </summary>
    public ContainerAppRegistration Registration 
    {
        get { Initialize(); return _registration!; }
        set { Initialize(); AssignOrReplace(ref _registration, value); }
    }
    private ContainerAppRegistration? _registration;

    /// <summary>
    /// The version of the Facebook api to be used while logging in.
    /// </summary>
    public BicepValue<string> GraphApiVersion 
    {
        get { Initialize(); return _graphApiVersion!; }
        set { Initialize(); _graphApiVersion!.Assign(value); }
    }
    private BicepValue<string>? _graphApiVersion;

    /// <summary>
    /// A list of the scopes that should be requested while authenticating.
    /// </summary>
    public BicepList<string> LoginScopes 
    {
        get { Initialize(); return _loginScopes!; }
        set { Initialize(); _loginScopes!.Assign(value); }
    }
    private BicepList<string>? _loginScopes;

    /// <summary>
    /// Creates a new ContainerAppFacebookConfiguration.
    /// </summary>
    public ContainerAppFacebookConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppFacebookConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _registration = DefineModelProperty<ContainerAppRegistration>("Registration", ["registration"]);
        _graphApiVersion = DefineProperty<string>("GraphApiVersion", ["graphApiVersion"]);
        _loginScopes = DefineListProperty<string>("LoginScopes", ["login", "scopes"]);
    }
}
