// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The complex type of the extended location.
/// </summary>
public partial class ContainerAppExtendedLocation : ProvisionableConstruct
{
    /// <summary>
    /// The name of the extended location.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The type of the extended location.
    /// </summary>
    public BicepValue<ContainerAppExtendedLocationType> ExtendedLocationType 
    {
        get { Initialize(); return _extendedLocationType!; }
        set { Initialize(); _extendedLocationType!.Assign(value); }
    }
    private BicepValue<ContainerAppExtendedLocationType>? _extendedLocationType;

    /// <summary>
    /// Creates a new ContainerAppExtendedLocation.
    /// </summary>
    public ContainerAppExtendedLocation()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppExtendedLocation.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _extendedLocationType = DefineProperty<ContainerAppExtendedLocationType>("ExtendedLocationType", ["type"]);
    }
}
