// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Container App container environment variable.
/// </summary>
public partial class ContainerAppEnvironmentVariable : ProvisionableConstruct
{
    /// <summary>
    /// Environment variable name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Non-secret environment variable value.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// Name of the Container App secret from which to pull the environment
    /// variable value.
    /// </summary>
    public BicepValue<string> SecretRef 
    {
        get { Initialize(); return _secretRef!; }
        set { Initialize(); _secretRef!.Assign(value); }
    }
    private BicepValue<string>? _secretRef;

    /// <summary>
    /// Creates a new ContainerAppEnvironmentVariable.
    /// </summary>
    public ContainerAppEnvironmentVariable()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppEnvironmentVariable.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _value = DefineProperty<string>("Value", ["value"]);
        _secretRef = DefineProperty<string>("SecretRef", ["secretRef"]);
    }
}
