// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Dapr component metadata.
/// </summary>
public partial class ContainerAppDaprMetadata : ProvisionableConstruct
{
    /// <summary>
    /// Metadata property name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Metadata property value.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// Name of the Dapr Component secret from which to pull the metadata
    /// property value.
    /// </summary>
    public BicepValue<string> SecretRef 
    {
        get { Initialize(); return _secretRef!; }
        set { Initialize(); _secretRef!.Assign(value); }
    }
    private BicepValue<string>? _secretRef;

    /// <summary>
    /// Creates a new ContainerAppDaprMetadata.
    /// </summary>
    public ContainerAppDaprMetadata()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppDaprMetadata.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _value = DefineProperty<string>("Value", ["value"]);
        _secretRef = DefineProperty<string>("SecretRef", ["secretRef"]);
    }
}
