// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Container App container Custom scaling rule.
/// </summary>
public partial class ContainerAppCustomScaleRule : ProvisionableConstruct
{
    /// <summary>
    /// Type of the custom scale rule             eg: azure-servicebus, redis
    /// etc.
    /// </summary>
    public BicepValue<string> CustomScaleRuleType 
    {
        get { Initialize(); return _customScaleRuleType!; }
        set { Initialize(); _customScaleRuleType!.Assign(value); }
    }
    private BicepValue<string>? _customScaleRuleType;

    /// <summary>
    /// Metadata properties to describe custom scale rule.
    /// </summary>
    public BicepDictionary<string> Metadata 
    {
        get { Initialize(); return _metadata!; }
        set { Initialize(); _metadata!.Assign(value); }
    }
    private BicepDictionary<string>? _metadata;

    /// <summary>
    /// Authentication secrets for the custom scale rule.
    /// </summary>
    public BicepList<ContainerAppScaleRuleAuth> Auth 
    {
        get { Initialize(); return _auth!; }
        set { Initialize(); _auth!.Assign(value); }
    }
    private BicepList<ContainerAppScaleRuleAuth>? _auth;

    /// <summary>
    /// Creates a new ContainerAppCustomScaleRule.
    /// </summary>
    public ContainerAppCustomScaleRule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppCustomScaleRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _customScaleRuleType = DefineProperty<string>("CustomScaleRuleType", ["type"]);
        _metadata = DefineDictionaryProperty<string>("Metadata", ["metadata"]);
        _auth = DefineListProperty<ContainerAppScaleRuleAuth>("Auth", ["auth"]);
    }
}
